<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BudgetBillMonthlyAmount Struct
 * @subpackage Structs
 */
class BudgetBillMonthlyAmount extends AbstractStructBase
{
    /**
     * The BudgetBillMonthlyAmountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BudgetBillMonthlyAmountID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The BillCycleNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillCycleNumber;
    /**
     * The ActualRateValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ActualRateValue;
    /**
     * The DeltaBudgetBillActualBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DeltaBudgetBillActualBill;
    /**
     * The BudgetBillAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BudgetBillAmount;
    /**
     * The ActualUsageAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ActualUsageAmount;
    /**
     * The ActualBillAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ActualBillAmount;
    /**
     * The CumulativeDefferedBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CumulativeDefferedBalance;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The CumulativeDeferredBalanceAdder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CumulativeDeferredBalanceAdder;
    /**
     * The IsTrueUpBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTrueUpBill;
    /**
     * The IsEndTrueUpBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEndTrueUpBill;
    /**
     * The BudgetBillingTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BudgetBillingTypeID;
    /**
     * The BillNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillNumber;
    /**
     * The ServicePoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ServicePoint
     */
    public $ServicePoint;
    /**
     * Constructor method for BudgetBillMonthlyAmount
     * @uses BudgetBillMonthlyAmount::setBudgetBillMonthlyAmountID()
     * @uses BudgetBillMonthlyAmount::setAccountID()
     * @uses BudgetBillMonthlyAmount::setAccountServicePointID()
     * @uses BudgetBillMonthlyAmount::setBillCycleNumber()
     * @uses BudgetBillMonthlyAmount::setActualRateValue()
     * @uses BudgetBillMonthlyAmount::setDeltaBudgetBillActualBill()
     * @uses BudgetBillMonthlyAmount::setBudgetBillAmount()
     * @uses BudgetBillMonthlyAmount::setActualUsageAmount()
     * @uses BudgetBillMonthlyAmount::setActualBillAmount()
     * @uses BudgetBillMonthlyAmount::setCumulativeDefferedBalance()
     * @uses BudgetBillMonthlyAmount::setCreateDate()
     * @uses BudgetBillMonthlyAmount::setLastUpdateDate()
     * @uses BudgetBillMonthlyAmount::setBillID()
     * @uses BudgetBillMonthlyAmount::setCumulativeDeferredBalanceAdder()
     * @uses BudgetBillMonthlyAmount::setIsTrueUpBill()
     * @uses BudgetBillMonthlyAmount::setIsEndTrueUpBill()
     * @uses BudgetBillMonthlyAmount::setBudgetBillingTypeID()
     * @uses BudgetBillMonthlyAmount::setBillNumber()
     * @uses BudgetBillMonthlyAmount::setServicePoint()
     * @param int $budgetBillMonthlyAmountID
     * @param int $accountID
     * @param int $accountServicePointID
     * @param int $billCycleNumber
     * @param float $actualRateValue
     * @param float $deltaBudgetBillActualBill
     * @param float $budgetBillAmount
     * @param float $actualUsageAmount
     * @param float $actualBillAmount
     * @param float $cumulativeDefferedBalance
     * @param string $createDate
     * @param string $lastUpdateDate
     * @param int $billID
     * @param float $cumulativeDeferredBalanceAdder
     * @param bool $isTrueUpBill
     * @param bool $isEndTrueUpBill
     * @param int $budgetBillingTypeID
     * @param string $billNumber
     * @param \SGCIS\Struct\ServicePoint $servicePoint
     */
    public function __construct($budgetBillMonthlyAmountID = null, $accountID = null, $accountServicePointID = null, $billCycleNumber = null, $actualRateValue = null, $deltaBudgetBillActualBill = null, $budgetBillAmount = null, $actualUsageAmount = null, $actualBillAmount = null, $cumulativeDefferedBalance = null, $createDate = null, $lastUpdateDate = null, $billID = null, $cumulativeDeferredBalanceAdder = null, $isTrueUpBill = null, $isEndTrueUpBill = null, $budgetBillingTypeID = null, $billNumber = null, \SGCIS\Struct\ServicePoint $servicePoint = null)
    {
        $this
            ->setBudgetBillMonthlyAmountID($budgetBillMonthlyAmountID)
            ->setAccountID($accountID)
            ->setAccountServicePointID($accountServicePointID)
            ->setBillCycleNumber($billCycleNumber)
            ->setActualRateValue($actualRateValue)
            ->setDeltaBudgetBillActualBill($deltaBudgetBillActualBill)
            ->setBudgetBillAmount($budgetBillAmount)
            ->setActualUsageAmount($actualUsageAmount)
            ->setActualBillAmount($actualBillAmount)
            ->setCumulativeDefferedBalance($cumulativeDefferedBalance)
            ->setCreateDate($createDate)
            ->setLastUpdateDate($lastUpdateDate)
            ->setBillID($billID)
            ->setCumulativeDeferredBalanceAdder($cumulativeDeferredBalanceAdder)
            ->setIsTrueUpBill($isTrueUpBill)
            ->setIsEndTrueUpBill($isEndTrueUpBill)
            ->setBudgetBillingTypeID($budgetBillingTypeID)
            ->setBillNumber($billNumber)
            ->setServicePoint($servicePoint);
    }
    /**
     * Get BudgetBillMonthlyAmountID value
     * @return int
     */
    public function getBudgetBillMonthlyAmountID()
    {
        return $this->BudgetBillMonthlyAmountID;
    }
    /**
     * Set BudgetBillMonthlyAmountID value
     * @param int $budgetBillMonthlyAmountID
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setBudgetBillMonthlyAmountID($budgetBillMonthlyAmountID = null)
    {
        // validation for constraint: int
        if (!is_null($budgetBillMonthlyAmountID) && !is_numeric($budgetBillMonthlyAmountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($budgetBillMonthlyAmountID)), __LINE__);
        }
        $this->BudgetBillMonthlyAmountID = $budgetBillMonthlyAmountID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get BillCycleNumber value
     * @return int
     */
    public function getBillCycleNumber()
    {
        return $this->BillCycleNumber;
    }
    /**
     * Set BillCycleNumber value
     * @param int $billCycleNumber
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setBillCycleNumber($billCycleNumber = null)
    {
        // validation for constraint: int
        if (!is_null($billCycleNumber) && !is_numeric($billCycleNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billCycleNumber)), __LINE__);
        }
        $this->BillCycleNumber = $billCycleNumber;
        return $this;
    }
    /**
     * Get ActualRateValue value
     * @return float
     */
    public function getActualRateValue()
    {
        return $this->ActualRateValue;
    }
    /**
     * Set ActualRateValue value
     * @param float $actualRateValue
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setActualRateValue($actualRateValue = null)
    {
        $this->ActualRateValue = $actualRateValue;
        return $this;
    }
    /**
     * Get DeltaBudgetBillActualBill value
     * @return float
     */
    public function getDeltaBudgetBillActualBill()
    {
        return $this->DeltaBudgetBillActualBill;
    }
    /**
     * Set DeltaBudgetBillActualBill value
     * @param float $deltaBudgetBillActualBill
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setDeltaBudgetBillActualBill($deltaBudgetBillActualBill = null)
    {
        $this->DeltaBudgetBillActualBill = $deltaBudgetBillActualBill;
        return $this;
    }
    /**
     * Get BudgetBillAmount value
     * @return float
     */
    public function getBudgetBillAmount()
    {
        return $this->BudgetBillAmount;
    }
    /**
     * Set BudgetBillAmount value
     * @param float $budgetBillAmount
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setBudgetBillAmount($budgetBillAmount = null)
    {
        $this->BudgetBillAmount = $budgetBillAmount;
        return $this;
    }
    /**
     * Get ActualUsageAmount value
     * @return float
     */
    public function getActualUsageAmount()
    {
        return $this->ActualUsageAmount;
    }
    /**
     * Set ActualUsageAmount value
     * @param float $actualUsageAmount
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setActualUsageAmount($actualUsageAmount = null)
    {
        $this->ActualUsageAmount = $actualUsageAmount;
        return $this;
    }
    /**
     * Get ActualBillAmount value
     * @return float
     */
    public function getActualBillAmount()
    {
        return $this->ActualBillAmount;
    }
    /**
     * Set ActualBillAmount value
     * @param float $actualBillAmount
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setActualBillAmount($actualBillAmount = null)
    {
        $this->ActualBillAmount = $actualBillAmount;
        return $this;
    }
    /**
     * Get CumulativeDefferedBalance value
     * @return float
     */
    public function getCumulativeDefferedBalance()
    {
        return $this->CumulativeDefferedBalance;
    }
    /**
     * Set CumulativeDefferedBalance value
     * @param float $cumulativeDefferedBalance
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setCumulativeDefferedBalance($cumulativeDefferedBalance = null)
    {
        $this->CumulativeDefferedBalance = $cumulativeDefferedBalance;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get CumulativeDeferredBalanceAdder value
     * @return float
     */
    public function getCumulativeDeferredBalanceAdder()
    {
        return $this->CumulativeDeferredBalanceAdder;
    }
    /**
     * Set CumulativeDeferredBalanceAdder value
     * @param float $cumulativeDeferredBalanceAdder
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setCumulativeDeferredBalanceAdder($cumulativeDeferredBalanceAdder = null)
    {
        $this->CumulativeDeferredBalanceAdder = $cumulativeDeferredBalanceAdder;
        return $this;
    }
    /**
     * Get IsTrueUpBill value
     * @return bool
     */
    public function getIsTrueUpBill()
    {
        return $this->IsTrueUpBill;
    }
    /**
     * Set IsTrueUpBill value
     * @param bool $isTrueUpBill
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setIsTrueUpBill($isTrueUpBill = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTrueUpBill) && !is_bool($isTrueUpBill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTrueUpBill)), __LINE__);
        }
        $this->IsTrueUpBill = $isTrueUpBill;
        return $this;
    }
    /**
     * Get IsEndTrueUpBill value
     * @return bool
     */
    public function getIsEndTrueUpBill()
    {
        return $this->IsEndTrueUpBill;
    }
    /**
     * Set IsEndTrueUpBill value
     * @param bool $isEndTrueUpBill
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setIsEndTrueUpBill($isEndTrueUpBill = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEndTrueUpBill) && !is_bool($isEndTrueUpBill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEndTrueUpBill)), __LINE__);
        }
        $this->IsEndTrueUpBill = $isEndTrueUpBill;
        return $this;
    }
    /**
     * Get BudgetBillingTypeID value
     * @return int
     */
    public function getBudgetBillingTypeID()
    {
        return $this->BudgetBillingTypeID;
    }
    /**
     * Set BudgetBillingTypeID value
     * @param int $budgetBillingTypeID
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setBudgetBillingTypeID($budgetBillingTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($budgetBillingTypeID) && !is_numeric($budgetBillingTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($budgetBillingTypeID)), __LINE__);
        }
        $this->BudgetBillingTypeID = $budgetBillingTypeID;
        return $this;
    }
    /**
     * Get BillNumber value
     * @return string|null
     */
    public function getBillNumber()
    {
        return $this->BillNumber;
    }
    /**
     * Set BillNumber value
     * @param string $billNumber
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setBillNumber($billNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billNumber) && !is_string($billNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billNumber)), __LINE__);
        }
        $this->BillNumber = $billNumber;
        return $this;
    }
    /**
     * Get ServicePoint value
     * @return \SGCIS\Struct\ServicePoint|null
     */
    public function getServicePoint()
    {
        return $this->ServicePoint;
    }
    /**
     * Set ServicePoint value
     * @param \SGCIS\Struct\ServicePoint $servicePoint
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public function setServicePoint(\SGCIS\Struct\ServicePoint $servicePoint = null)
    {
        $this->ServicePoint = $servicePoint;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
