<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillDeliveryMethod Struct
 * @subpackage Structs
 */
class BillDeliveryMethod extends AbstractStructBase
{
    /**
     * The BillDeliveryMethodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillDeliveryMethodID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for BillDeliveryMethod
     * @uses BillDeliveryMethod::setBillDeliveryMethodID()
     * @uses BillDeliveryMethod::setName()
     * @param int $billDeliveryMethodID
     * @param string $name
     */
    public function __construct($billDeliveryMethodID = null, $name = null)
    {
        $this
            ->setBillDeliveryMethodID($billDeliveryMethodID)
            ->setName($name);
    }
    /**
     * Get BillDeliveryMethodID value
     * @return int
     */
    public function getBillDeliveryMethodID()
    {
        return $this->BillDeliveryMethodID;
    }
    /**
     * Set BillDeliveryMethodID value
     * @param int $billDeliveryMethodID
     * @return \SGCIS\Struct\BillDeliveryMethod
     */
    public function setBillDeliveryMethodID($billDeliveryMethodID = null)
    {
        // validation for constraint: int
        if (!is_null($billDeliveryMethodID) && !is_numeric($billDeliveryMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billDeliveryMethodID)), __LINE__);
        }
        $this->BillDeliveryMethodID = $billDeliveryMethodID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\BillDeliveryMethod
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillDeliveryMethod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
