<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillChargeDisplayItem Struct
 * @subpackage Structs
 */
class BillChargeDisplayItem extends AbstractStructBase
{
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The BillServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillServicePointID;
    /**
     * The BillServicePointChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillServicePointChargeID;
    /**
     * The BillServicePointChargeTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillServicePointChargeTypeID;
    /**
     * The TransactionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransactionID;
    /**
     * The BillStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillStatusID;
    /**
     * The BillAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BillAmount;
    /**
     * The PeriodStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodStartDate;
    /**
     * The PeriodEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodEndDate;
    /**
     * The TotalUsageAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalUsageAmount;
    /**
     * The TotalEnergyCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalEnergyCharges;
    /**
     * The TotalTDUBaseCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalTDUBaseCharges;
    /**
     * The TotalTDUDeliveryCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalTDUDeliveryCharges;
    /**
     * The MarketTransactionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MarketTransactionDate;
    /**
     * The IsApproved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsApproved;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The Guid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Guid;
    /**
     * The ServiceProviderIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderIdentifier;
    /**
     * The ServiceLocationAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceLocationAddress;
    /**
     * The DocumentTrackingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTrackingNumber;
    /**
     * The TransactionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionType;
    /**
     * The ChargeTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeTypeName;
    /**
     * The ExceptionsList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExceptionsList;
    /**
     * The BillStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillStatusName;
    /**
     * Constructor method for BillChargeDisplayItem
     * @uses BillChargeDisplayItem::setBillID()
     * @uses BillChargeDisplayItem::setBillServicePointID()
     * @uses BillChargeDisplayItem::setBillServicePointChargeID()
     * @uses BillChargeDisplayItem::setBillServicePointChargeTypeID()
     * @uses BillChargeDisplayItem::setTransactionID()
     * @uses BillChargeDisplayItem::setBillStatusID()
     * @uses BillChargeDisplayItem::setBillAmount()
     * @uses BillChargeDisplayItem::setPeriodStartDate()
     * @uses BillChargeDisplayItem::setPeriodEndDate()
     * @uses BillChargeDisplayItem::setTotalUsageAmount()
     * @uses BillChargeDisplayItem::setTotalEnergyCharges()
     * @uses BillChargeDisplayItem::setTotalTDUBaseCharges()
     * @uses BillChargeDisplayItem::setTotalTDUDeliveryCharges()
     * @uses BillChargeDisplayItem::setMarketTransactionDate()
     * @uses BillChargeDisplayItem::setIsApproved()
     * @uses BillChargeDisplayItem::setAccountServicePointID()
     * @uses BillChargeDisplayItem::setGuid()
     * @uses BillChargeDisplayItem::setServiceProviderIdentifier()
     * @uses BillChargeDisplayItem::setServiceLocationAddress()
     * @uses BillChargeDisplayItem::setDocumentTrackingNumber()
     * @uses BillChargeDisplayItem::setTransactionType()
     * @uses BillChargeDisplayItem::setChargeTypeName()
     * @uses BillChargeDisplayItem::setExceptionsList()
     * @uses BillChargeDisplayItem::setBillStatusName()
     * @param int $billID
     * @param int $billServicePointID
     * @param int $billServicePointChargeID
     * @param int $billServicePointChargeTypeID
     * @param int $transactionID
     * @param int $billStatusID
     * @param float $billAmount
     * @param string $periodStartDate
     * @param string $periodEndDate
     * @param float $totalUsageAmount
     * @param float $totalEnergyCharges
     * @param float $totalTDUBaseCharges
     * @param float $totalTDUDeliveryCharges
     * @param string $marketTransactionDate
     * @param bool $isApproved
     * @param int $accountServicePointID
     * @param string $guid
     * @param string $serviceProviderIdentifier
     * @param string $serviceLocationAddress
     * @param string $documentTrackingNumber
     * @param string $transactionType
     * @param string $chargeTypeName
     * @param string $exceptionsList
     * @param string $billStatusName
     */
    public function __construct($billID = null, $billServicePointID = null, $billServicePointChargeID = null, $billServicePointChargeTypeID = null, $transactionID = null, $billStatusID = null, $billAmount = null, $periodStartDate = null, $periodEndDate = null, $totalUsageAmount = null, $totalEnergyCharges = null, $totalTDUBaseCharges = null, $totalTDUDeliveryCharges = null, $marketTransactionDate = null, $isApproved = null, $accountServicePointID = null, $guid = null, $serviceProviderIdentifier = null, $serviceLocationAddress = null, $documentTrackingNumber = null, $transactionType = null, $chargeTypeName = null, $exceptionsList = null, $billStatusName = null)
    {
        $this
            ->setBillID($billID)
            ->setBillServicePointID($billServicePointID)
            ->setBillServicePointChargeID($billServicePointChargeID)
            ->setBillServicePointChargeTypeID($billServicePointChargeTypeID)
            ->setTransactionID($transactionID)
            ->setBillStatusID($billStatusID)
            ->setBillAmount($billAmount)
            ->setPeriodStartDate($periodStartDate)
            ->setPeriodEndDate($periodEndDate)
            ->setTotalUsageAmount($totalUsageAmount)
            ->setTotalEnergyCharges($totalEnergyCharges)
            ->setTotalTDUBaseCharges($totalTDUBaseCharges)
            ->setTotalTDUDeliveryCharges($totalTDUDeliveryCharges)
            ->setMarketTransactionDate($marketTransactionDate)
            ->setIsApproved($isApproved)
            ->setAccountServicePointID($accountServicePointID)
            ->setGuid($guid)
            ->setServiceProviderIdentifier($serviceProviderIdentifier)
            ->setServiceLocationAddress($serviceLocationAddress)
            ->setDocumentTrackingNumber($documentTrackingNumber)
            ->setTransactionType($transactionType)
            ->setChargeTypeName($chargeTypeName)
            ->setExceptionsList($exceptionsList)
            ->setBillStatusName($billStatusName);
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get BillServicePointID value
     * @return int
     */
    public function getBillServicePointID()
    {
        return $this->BillServicePointID;
    }
    /**
     * Set BillServicePointID value
     * @param int $billServicePointID
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setBillServicePointID($billServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($billServicePointID) && !is_numeric($billServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billServicePointID)), __LINE__);
        }
        $this->BillServicePointID = $billServicePointID;
        return $this;
    }
    /**
     * Get BillServicePointChargeID value
     * @return int
     */
    public function getBillServicePointChargeID()
    {
        return $this->BillServicePointChargeID;
    }
    /**
     * Set BillServicePointChargeID value
     * @param int $billServicePointChargeID
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setBillServicePointChargeID($billServicePointChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($billServicePointChargeID) && !is_numeric($billServicePointChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billServicePointChargeID)), __LINE__);
        }
        $this->BillServicePointChargeID = $billServicePointChargeID;
        return $this;
    }
    /**
     * Get BillServicePointChargeTypeID value
     * @return int
     */
    public function getBillServicePointChargeTypeID()
    {
        return $this->BillServicePointChargeTypeID;
    }
    /**
     * Set BillServicePointChargeTypeID value
     * @param int $billServicePointChargeTypeID
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setBillServicePointChargeTypeID($billServicePointChargeTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($billServicePointChargeTypeID) && !is_numeric($billServicePointChargeTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billServicePointChargeTypeID)), __LINE__);
        }
        $this->BillServicePointChargeTypeID = $billServicePointChargeTypeID;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return int
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param int $transactionID
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: int
        if (!is_null($transactionID) && !is_numeric($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get BillStatusID value
     * @return int
     */
    public function getBillStatusID()
    {
        return $this->BillStatusID;
    }
    /**
     * Set BillStatusID value
     * @param int $billStatusID
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setBillStatusID($billStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($billStatusID) && !is_numeric($billStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billStatusID)), __LINE__);
        }
        $this->BillStatusID = $billStatusID;
        return $this;
    }
    /**
     * Get BillAmount value
     * @return float
     */
    public function getBillAmount()
    {
        return $this->BillAmount;
    }
    /**
     * Set BillAmount value
     * @param float $billAmount
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setBillAmount($billAmount = null)
    {
        $this->BillAmount = $billAmount;
        return $this;
    }
    /**
     * Get PeriodStartDate value
     * @return string
     */
    public function getPeriodStartDate()
    {
        return $this->PeriodStartDate;
    }
    /**
     * Set PeriodStartDate value
     * @param string $periodStartDate
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setPeriodStartDate($periodStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodStartDate) && !is_string($periodStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodStartDate)), __LINE__);
        }
        $this->PeriodStartDate = $periodStartDate;
        return $this;
    }
    /**
     * Get PeriodEndDate value
     * @return string
     */
    public function getPeriodEndDate()
    {
        return $this->PeriodEndDate;
    }
    /**
     * Set PeriodEndDate value
     * @param string $periodEndDate
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setPeriodEndDate($periodEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodEndDate) && !is_string($periodEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodEndDate)), __LINE__);
        }
        $this->PeriodEndDate = $periodEndDate;
        return $this;
    }
    /**
     * Get TotalUsageAmount value
     * @return float
     */
    public function getTotalUsageAmount()
    {
        return $this->TotalUsageAmount;
    }
    /**
     * Set TotalUsageAmount value
     * @param float $totalUsageAmount
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setTotalUsageAmount($totalUsageAmount = null)
    {
        $this->TotalUsageAmount = $totalUsageAmount;
        return $this;
    }
    /**
     * Get TotalEnergyCharges value
     * @return float
     */
    public function getTotalEnergyCharges()
    {
        return $this->TotalEnergyCharges;
    }
    /**
     * Set TotalEnergyCharges value
     * @param float $totalEnergyCharges
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setTotalEnergyCharges($totalEnergyCharges = null)
    {
        $this->TotalEnergyCharges = $totalEnergyCharges;
        return $this;
    }
    /**
     * Get TotalTDUBaseCharges value
     * @return float
     */
    public function getTotalTDUBaseCharges()
    {
        return $this->TotalTDUBaseCharges;
    }
    /**
     * Set TotalTDUBaseCharges value
     * @param float $totalTDUBaseCharges
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setTotalTDUBaseCharges($totalTDUBaseCharges = null)
    {
        $this->TotalTDUBaseCharges = $totalTDUBaseCharges;
        return $this;
    }
    /**
     * Get TotalTDUDeliveryCharges value
     * @return float
     */
    public function getTotalTDUDeliveryCharges()
    {
        return $this->TotalTDUDeliveryCharges;
    }
    /**
     * Set TotalTDUDeliveryCharges value
     * @param float $totalTDUDeliveryCharges
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setTotalTDUDeliveryCharges($totalTDUDeliveryCharges = null)
    {
        $this->TotalTDUDeliveryCharges = $totalTDUDeliveryCharges;
        return $this;
    }
    /**
     * Get MarketTransactionDate value
     * @return string
     */
    public function getMarketTransactionDate()
    {
        return $this->MarketTransactionDate;
    }
    /**
     * Set MarketTransactionDate value
     * @param string $marketTransactionDate
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setMarketTransactionDate($marketTransactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($marketTransactionDate) && !is_string($marketTransactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketTransactionDate)), __LINE__);
        }
        $this->MarketTransactionDate = $marketTransactionDate;
        return $this;
    }
    /**
     * Get IsApproved value
     * @return bool
     */
    public function getIsApproved()
    {
        return $this->IsApproved;
    }
    /**
     * Set IsApproved value
     * @param bool $isApproved
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setIsApproved($isApproved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApproved) && !is_bool($isApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isApproved)), __LINE__);
        }
        $this->IsApproved = $isApproved;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get Guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->Guid;
    }
    /**
     * Set Guid value
     * @param string $guid
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guid)), __LINE__);
        }
        $this->Guid = $guid;
        return $this;
    }
    /**
     * Get ServiceProviderIdentifier value
     * @return string|null
     */
    public function getServiceProviderIdentifier()
    {
        return $this->ServiceProviderIdentifier;
    }
    /**
     * Set ServiceProviderIdentifier value
     * @param string $serviceProviderIdentifier
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setServiceProviderIdentifier($serviceProviderIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderIdentifier) && !is_string($serviceProviderIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderIdentifier)), __LINE__);
        }
        $this->ServiceProviderIdentifier = $serviceProviderIdentifier;
        return $this;
    }
    /**
     * Get ServiceLocationAddress value
     * @return string|null
     */
    public function getServiceLocationAddress()
    {
        return $this->ServiceLocationAddress;
    }
    /**
     * Set ServiceLocationAddress value
     * @param string $serviceLocationAddress
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setServiceLocationAddress($serviceLocationAddress = null)
    {
        // validation for constraint: string
        if (!is_null($serviceLocationAddress) && !is_string($serviceLocationAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceLocationAddress)), __LINE__);
        }
        $this->ServiceLocationAddress = $serviceLocationAddress;
        return $this;
    }
    /**
     * Get DocumentTrackingNumber value
     * @return string|null
     */
    public function getDocumentTrackingNumber()
    {
        return $this->DocumentTrackingNumber;
    }
    /**
     * Set DocumentTrackingNumber value
     * @param string $documentTrackingNumber
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setDocumentTrackingNumber($documentTrackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentTrackingNumber) && !is_string($documentTrackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentTrackingNumber)), __LINE__);
        }
        $this->DocumentTrackingNumber = $documentTrackingNumber;
        return $this;
    }
    /**
     * Get TransactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @param string $transactionType
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: string
        if (!is_null($transactionType) && !is_string($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionType)), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Get ChargeTypeName value
     * @return string|null
     */
    public function getChargeTypeName()
    {
        return $this->ChargeTypeName;
    }
    /**
     * Set ChargeTypeName value
     * @param string $chargeTypeName
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setChargeTypeName($chargeTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($chargeTypeName) && !is_string($chargeTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeTypeName)), __LINE__);
        }
        $this->ChargeTypeName = $chargeTypeName;
        return $this;
    }
    /**
     * Get ExceptionsList value
     * @return string|null
     */
    public function getExceptionsList()
    {
        return $this->ExceptionsList;
    }
    /**
     * Set ExceptionsList value
     * @param string $exceptionsList
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setExceptionsList($exceptionsList = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionsList) && !is_string($exceptionsList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionsList)), __LINE__);
        }
        $this->ExceptionsList = $exceptionsList;
        return $this;
    }
    /**
     * Get BillStatusName value
     * @return string|null
     */
    public function getBillStatusName()
    {
        return $this->BillStatusName;
    }
    /**
     * Set BillStatusName value
     * @param string $billStatusName
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public function setBillStatusName($billStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($billStatusName) && !is_string($billStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billStatusName)), __LINE__);
        }
        $this->BillStatusName = $billStatusName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillChargeDisplayItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
