<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseDTO Struct
 * @subpackage Structs
 */
class BaseDTO extends AbstractStructBase
{
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The CreatedByUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreatedByUserID;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The LastUpdateUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LastUpdateUserID;
    /**
     * The LastUpdateUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastUpdateUserName;
    /**
     * The CreateUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreateUserName;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for BaseDTO
     * @uses BaseDTO::setCreateDate()
     * @uses BaseDTO::setCreatedByUserID()
     * @uses BaseDTO::setLastUpdateDate()
     * @uses BaseDTO::setLastUpdateUserID()
     * @uses BaseDTO::setLastUpdateUserName()
     * @uses BaseDTO::setCreateUserName()
     * @uses BaseDTO::setErrorMessage()
     * @param string $createDate
     * @param int $createdByUserID
     * @param string $lastUpdateDate
     * @param int $lastUpdateUserID
     * @param string $lastUpdateUserName
     * @param string $createUserName
     * @param string $errorMessage
     */
    public function __construct($createDate = null, $createdByUserID = null, $lastUpdateDate = null, $lastUpdateUserID = null, $lastUpdateUserName = null, $createUserName = null, $errorMessage = null)
    {
        $this
            ->setCreateDate($createDate)
            ->setCreatedByUserID($createdByUserID)
            ->setLastUpdateDate($lastUpdateDate)
            ->setLastUpdateUserID($lastUpdateUserID)
            ->setLastUpdateUserName($lastUpdateUserName)
            ->setCreateUserName($createUserName)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\BaseDTO
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreatedByUserID value
     * @return int
     */
    public function getCreatedByUserID()
    {
        return $this->CreatedByUserID;
    }
    /**
     * Set CreatedByUserID value
     * @param int $createdByUserID
     * @return \SGCIS\Struct\BaseDTO
     */
    public function setCreatedByUserID($createdByUserID = null)
    {
        // validation for constraint: int
        if (!is_null($createdByUserID) && !is_numeric($createdByUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($createdByUserID)), __LINE__);
        }
        $this->CreatedByUserID = $createdByUserID;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return \SGCIS\Struct\BaseDTO
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get LastUpdateUserID value
     * @return int
     */
    public function getLastUpdateUserID()
    {
        return $this->LastUpdateUserID;
    }
    /**
     * Set LastUpdateUserID value
     * @param int $lastUpdateUserID
     * @return \SGCIS\Struct\BaseDTO
     */
    public function setLastUpdateUserID($lastUpdateUserID = null)
    {
        // validation for constraint: int
        if (!is_null($lastUpdateUserID) && !is_numeric($lastUpdateUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lastUpdateUserID)), __LINE__);
        }
        $this->LastUpdateUserID = $lastUpdateUserID;
        return $this;
    }
    /**
     * Get LastUpdateUserName value
     * @return string|null
     */
    public function getLastUpdateUserName()
    {
        return $this->LastUpdateUserName;
    }
    /**
     * Set LastUpdateUserName value
     * @param string $lastUpdateUserName
     * @return \SGCIS\Struct\BaseDTO
     */
    public function setLastUpdateUserName($lastUpdateUserName = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateUserName) && !is_string($lastUpdateUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateUserName)), __LINE__);
        }
        $this->LastUpdateUserName = $lastUpdateUserName;
        return $this;
    }
    /**
     * Get CreateUserName value
     * @return string|null
     */
    public function getCreateUserName()
    {
        return $this->CreateUserName;
    }
    /**
     * Set CreateUserName value
     * @param string $createUserName
     * @return \SGCIS\Struct\BaseDTO
     */
    public function setCreateUserName($createUserName = null)
    {
        // validation for constraint: string
        if (!is_null($createUserName) && !is_string($createUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createUserName)), __LINE__);
        }
        $this->CreateUserName = $createUserName;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \SGCIS\Struct\BaseDTO
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BaseDTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
