<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutheticateUserResponse Struct
 * @subpackage Structs
 */
class AutheticateUserResponse extends ServiceResponseBase
{
    /**
     * The IsAuthenticated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAuthenticated;
    /**
     * The IsPasswordChangeRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPasswordChangeRequired;
    /**
     * The AutheticationErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfString
     */
    public $AutheticationErrors;
    /**
     * The Accounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccount
     */
    public $Accounts;
    /**
     * The Person
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Person
     */
    public $Person;
    /**
     * Constructor method for AutheticateUserResponse
     * @uses AutheticateUserResponse::setIsAuthenticated()
     * @uses AutheticateUserResponse::setIsPasswordChangeRequired()
     * @uses AutheticateUserResponse::setAutheticationErrors()
     * @uses AutheticateUserResponse::setAccounts()
     * @uses AutheticateUserResponse::setPerson()
     * @param bool $isAuthenticated
     * @param bool $isPasswordChangeRequired
     * @param \SGCIS\Array\ArrayOfString $autheticationErrors
     * @param \SGCIS\Array\ArrayOfAccount $accounts
     * @param \SGCIS\Struct\Person $person
     */
    public function __construct($isAuthenticated = null, $isPasswordChangeRequired = null, \SGCIS\Array\ArrayOfString $autheticationErrors = null, \SGCIS\Array\ArrayOfAccount $accounts = null, \SGCIS\Struct\Person $person = null)
    {
        $this
            ->setIsAuthenticated($isAuthenticated)
            ->setIsPasswordChangeRequired($isPasswordChangeRequired)
            ->setAutheticationErrors($autheticationErrors)
            ->setAccounts($accounts)
            ->setPerson($person);
    }
    /**
     * Get IsAuthenticated value
     * @return bool
     */
    public function getIsAuthenticated()
    {
        return $this->IsAuthenticated;
    }
    /**
     * Set IsAuthenticated value
     * @param bool $isAuthenticated
     * @return \SGCIS\Struct\AutheticateUserResponse
     */
    public function setIsAuthenticated($isAuthenticated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAuthenticated) && !is_bool($isAuthenticated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAuthenticated)), __LINE__);
        }
        $this->IsAuthenticated = $isAuthenticated;
        return $this;
    }
    /**
     * Get IsPasswordChangeRequired value
     * @return bool
     */
    public function getIsPasswordChangeRequired()
    {
        return $this->IsPasswordChangeRequired;
    }
    /**
     * Set IsPasswordChangeRequired value
     * @param bool $isPasswordChangeRequired
     * @return \SGCIS\Struct\AutheticateUserResponse
     */
    public function setIsPasswordChangeRequired($isPasswordChangeRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPasswordChangeRequired) && !is_bool($isPasswordChangeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPasswordChangeRequired)), __LINE__);
        }
        $this->IsPasswordChangeRequired = $isPasswordChangeRequired;
        return $this;
    }
    /**
     * Get AutheticationErrors value
     * @return \SGCIS\Array\ArrayOfString|null
     */
    public function getAutheticationErrors()
    {
        return $this->AutheticationErrors;
    }
    /**
     * Set AutheticationErrors value
     * @param \SGCIS\Array\ArrayOfString $autheticationErrors
     * @return \SGCIS\Struct\AutheticateUserResponse
     */
    public function setAutheticationErrors(\SGCIS\Array\ArrayOfString $autheticationErrors = null)
    {
        $this->AutheticationErrors = $autheticationErrors;
        return $this;
    }
    /**
     * Get Accounts value
     * @return \SGCIS\Array\ArrayOfAccount|null
     */
    public function getAccounts()
    {
        return $this->Accounts;
    }
    /**
     * Set Accounts value
     * @param \SGCIS\Array\ArrayOfAccount $accounts
     * @return \SGCIS\Struct\AutheticateUserResponse
     */
    public function setAccounts(\SGCIS\Array\ArrayOfAccount $accounts = null)
    {
        $this->Accounts = $accounts;
        return $this;
    }
    /**
     * Get Person value
     * @return \SGCIS\Struct\Person|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \SGCIS\Struct\Person $person
     * @return \SGCIS\Struct\AutheticateUserResponse
     */
    public function setPerson(\SGCIS\Struct\Person $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AutheticateUserResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
