<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountServicePoint Struct
 * @subpackage Structs
 */
class AccountServicePoint extends BaseDTO
{
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The ServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointID;
    /**
     * The InactivationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InactivationDate;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The ServicePointStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointStatusID;
    /**
     * The ServicePointMeterID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointMeterID;
    /**
     * The ScheduledActionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ScheduledActionDate;
    /**
     * The MeterID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterID;
    /**
     * The MeterStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterStatusID;
    /**
     * The IsEnergyAssistance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEnergyAssistance;
    /**
     * The ServicePointStatusDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServicePointStatusDate;
    /**
     * The DistributionPointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionPointID;
    /**
     * The ServiceStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceStartDate;
    /**
     * The PremiseTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PremiseTypeID;
    /**
     * The IsBudgetBilling
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBudgetBilling;
    /**
     * The BudgetBillMonths
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BudgetBillMonths;
    /**
     * The BudgetBillingTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BudgetBillingTypeID;
    /**
     * The BudgetBillingTrueUpMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BudgetBillingTrueUpMonth;
    /**
     * The BudgetBillingStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BudgetBillingStartDate;
    /**
     * The BudgetBillingTrueUpNextBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $BudgetBillingTrueUpNextBill;
    /**
     * The StaticFlatBillAmountOnlyRead
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StaticFlatBillAmountOnlyRead;
    /**
     * The LastDisconnectDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastDisconnectDate;
    /**
     * The LastReconnectDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastReconnectDate;
    /**
     * The IsSwitchHoldBillPay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSwitchHoldBillPay;
    /**
     * The IsSwitchHoldTampering
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSwitchHoldTampering;
    /**
     * The IsCriticalCare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCriticalCare;
    /**
     * The IsTransfer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTransfer;
    /**
     * The TransferredFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransferredFrom;
    /**
     * The TransferredTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransferredTo;
    /**
     * The ThirdPartyVerificationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ThirdPartyVerificationID;
    /**
     * The BillThisAccountServicePoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $BillThisAccountServicePoint;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The BillingCycle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCycle;
    /**
     * The ServiceProviderIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderIdentifier;
    /**
     * The MeterSerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterSerialNumber;
    /**
     * The TaxCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxCode;
    /**
     * The ServicePointMeters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServicePointMeter
     */
    public $ServicePointMeters;
    /**
     * The ServicePoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ServicePoint
     */
    public $ServicePoint;
    /**
     * The ServiceAgreements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServiceAgreement
     */
    public $ServiceAgreements;
    /**
     * The AccountServicePointCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountServicePointTarrifCharge
     */
    public $AccountServicePointCharges;
    /**
     * The Rate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Rate
     */
    public $Rate;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The LegacySystem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LegacySystem;
    /**
     * The ThirdPartyVerificationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ThirdPartyVerificationName;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Product
     */
    public $Product;
    /**
     * Constructor method for AccountServicePoint
     * @uses AccountServicePoint::setAccountServicePointID()
     * @uses AccountServicePoint::setAccountID()
     * @uses AccountServicePoint::setServicePointID()
     * @uses AccountServicePoint::setInactivationDate()
     * @uses AccountServicePoint::setActive()
     * @uses AccountServicePoint::setProductID()
     * @uses AccountServicePoint::setServicePointStatusID()
     * @uses AccountServicePoint::setServicePointMeterID()
     * @uses AccountServicePoint::setScheduledActionDate()
     * @uses AccountServicePoint::setMeterID()
     * @uses AccountServicePoint::setMeterStatusID()
     * @uses AccountServicePoint::setIsEnergyAssistance()
     * @uses AccountServicePoint::setServicePointStatusDate()
     * @uses AccountServicePoint::setDistributionPointID()
     * @uses AccountServicePoint::setServiceStartDate()
     * @uses AccountServicePoint::setPremiseTypeID()
     * @uses AccountServicePoint::setIsBudgetBilling()
     * @uses AccountServicePoint::setBudgetBillMonths()
     * @uses AccountServicePoint::setBudgetBillingTypeID()
     * @uses AccountServicePoint::setBudgetBillingTrueUpMonth()
     * @uses AccountServicePoint::setBudgetBillingStartDate()
     * @uses AccountServicePoint::setBudgetBillingTrueUpNextBill()
     * @uses AccountServicePoint::setStaticFlatBillAmountOnlyRead()
     * @uses AccountServicePoint::setLastDisconnectDate()
     * @uses AccountServicePoint::setLastReconnectDate()
     * @uses AccountServicePoint::setIsSwitchHoldBillPay()
     * @uses AccountServicePoint::setIsSwitchHoldTampering()
     * @uses AccountServicePoint::setIsCriticalCare()
     * @uses AccountServicePoint::setIsTransfer()
     * @uses AccountServicePoint::setTransferredFrom()
     * @uses AccountServicePoint::setTransferredTo()
     * @uses AccountServicePoint::setThirdPartyVerificationID()
     * @uses AccountServicePoint::setBillThisAccountServicePoint()
     * @uses AccountServicePoint::setNotes()
     * @uses AccountServicePoint::setBillingCycle()
     * @uses AccountServicePoint::setServiceProviderIdentifier()
     * @uses AccountServicePoint::setMeterSerialNumber()
     * @uses AccountServicePoint::setTaxCode()
     * @uses AccountServicePoint::setServicePointMeters()
     * @uses AccountServicePoint::setServicePoint()
     * @uses AccountServicePoint::setServiceAgreements()
     * @uses AccountServicePoint::setAccountServicePointCharges()
     * @uses AccountServicePoint::setRate()
     * @uses AccountServicePoint::setAccountNumber()
     * @uses AccountServicePoint::setProductName()
     * @uses AccountServicePoint::setLegacySystem()
     * @uses AccountServicePoint::setThirdPartyVerificationName()
     * @uses AccountServicePoint::setProduct()
     * @param int $accountServicePointID
     * @param int $accountID
     * @param int $servicePointID
     * @param string $inactivationDate
     * @param bool $active
     * @param int $productID
     * @param int $servicePointStatusID
     * @param int $servicePointMeterID
     * @param string $scheduledActionDate
     * @param int $meterID
     * @param int $meterStatusID
     * @param bool $isEnergyAssistance
     * @param string $servicePointStatusDate
     * @param int $distributionPointID
     * @param string $serviceStartDate
     * @param int $premiseTypeID
     * @param bool $isBudgetBilling
     * @param int $budgetBillMonths
     * @param int $budgetBillingTypeID
     * @param int $budgetBillingTrueUpMonth
     * @param string $budgetBillingStartDate
     * @param bool $budgetBillingTrueUpNextBill
     * @param float $staticFlatBillAmountOnlyRead
     * @param string $lastDisconnectDate
     * @param string $lastReconnectDate
     * @param bool $isSwitchHoldBillPay
     * @param bool $isSwitchHoldTampering
     * @param bool $isCriticalCare
     * @param bool $isTransfer
     * @param int $transferredFrom
     * @param int $transferredTo
     * @param int $thirdPartyVerificationID
     * @param bool $billThisAccountServicePoint
     * @param string $notes
     * @param string $billingCycle
     * @param string $serviceProviderIdentifier
     * @param string $meterSerialNumber
     * @param string $taxCode
     * @param \SGCIS\Array\ArrayOfServicePointMeter $servicePointMeters
     * @param \SGCIS\Struct\ServicePoint $servicePoint
     * @param \SGCIS\Array\ArrayOfServiceAgreement $serviceAgreements
     * @param \SGCIS\Array\ArrayOfAccountServicePointTarrifCharge $accountServicePointCharges
     * @param \SGCIS\Struct\Rate $rate
     * @param string $accountNumber
     * @param string $productName
     * @param string $legacySystem
     * @param string $thirdPartyVerificationName
     * @param \SGCIS\Struct\Product $product
     */
    public function __construct($accountServicePointID = null, $accountID = null, $servicePointID = null, $inactivationDate = null, $active = null, $productID = null, $servicePointStatusID = null, $servicePointMeterID = null, $scheduledActionDate = null, $meterID = null, $meterStatusID = null, $isEnergyAssistance = null, $servicePointStatusDate = null, $distributionPointID = null, $serviceStartDate = null, $premiseTypeID = null, $isBudgetBilling = null, $budgetBillMonths = null, $budgetBillingTypeID = null, $budgetBillingTrueUpMonth = null, $budgetBillingStartDate = null, $budgetBillingTrueUpNextBill = null, $staticFlatBillAmountOnlyRead = null, $lastDisconnectDate = null, $lastReconnectDate = null, $isSwitchHoldBillPay = null, $isSwitchHoldTampering = null, $isCriticalCare = null, $isTransfer = null, $transferredFrom = null, $transferredTo = null, $thirdPartyVerificationID = null, $billThisAccountServicePoint = null, $notes = null, $billingCycle = null, $serviceProviderIdentifier = null, $meterSerialNumber = null, $taxCode = null, \SGCIS\Array\ArrayOfServicePointMeter $servicePointMeters = null, \SGCIS\Struct\ServicePoint $servicePoint = null, \SGCIS\Array\ArrayOfServiceAgreement $serviceAgreements = null, \SGCIS\Array\ArrayOfAccountServicePointTarrifCharge $accountServicePointCharges = null, \SGCIS\Struct\Rate $rate = null, $accountNumber = null, $productName = null, $legacySystem = null, $thirdPartyVerificationName = null, \SGCIS\Struct\Product $product = null)
    {
        $this
            ->setAccountServicePointID($accountServicePointID)
            ->setAccountID($accountID)
            ->setServicePointID($servicePointID)
            ->setInactivationDate($inactivationDate)
            ->setActive($active)
            ->setProductID($productID)
            ->setServicePointStatusID($servicePointStatusID)
            ->setServicePointMeterID($servicePointMeterID)
            ->setScheduledActionDate($scheduledActionDate)
            ->setMeterID($meterID)
            ->setMeterStatusID($meterStatusID)
            ->setIsEnergyAssistance($isEnergyAssistance)
            ->setServicePointStatusDate($servicePointStatusDate)
            ->setDistributionPointID($distributionPointID)
            ->setServiceStartDate($serviceStartDate)
            ->setPremiseTypeID($premiseTypeID)
            ->setIsBudgetBilling($isBudgetBilling)
            ->setBudgetBillMonths($budgetBillMonths)
            ->setBudgetBillingTypeID($budgetBillingTypeID)
            ->setBudgetBillingTrueUpMonth($budgetBillingTrueUpMonth)
            ->setBudgetBillingStartDate($budgetBillingStartDate)
            ->setBudgetBillingTrueUpNextBill($budgetBillingTrueUpNextBill)
            ->setStaticFlatBillAmountOnlyRead($staticFlatBillAmountOnlyRead)
            ->setLastDisconnectDate($lastDisconnectDate)
            ->setLastReconnectDate($lastReconnectDate)
            ->setIsSwitchHoldBillPay($isSwitchHoldBillPay)
            ->setIsSwitchHoldTampering($isSwitchHoldTampering)
            ->setIsCriticalCare($isCriticalCare)
            ->setIsTransfer($isTransfer)
            ->setTransferredFrom($transferredFrom)
            ->setTransferredTo($transferredTo)
            ->setThirdPartyVerificationID($thirdPartyVerificationID)
            ->setBillThisAccountServicePoint($billThisAccountServicePoint)
            ->setNotes($notes)
            ->setBillingCycle($billingCycle)
            ->setServiceProviderIdentifier($serviceProviderIdentifier)
            ->setMeterSerialNumber($meterSerialNumber)
            ->setTaxCode($taxCode)
            ->setServicePointMeters($servicePointMeters)
            ->setServicePoint($servicePoint)
            ->setServiceAgreements($serviceAgreements)
            ->setAccountServicePointCharges($accountServicePointCharges)
            ->setRate($rate)
            ->setAccountNumber($accountNumber)
            ->setProductName($productName)
            ->setLegacySystem($legacySystem)
            ->setThirdPartyVerificationName($thirdPartyVerificationName)
            ->setProduct($product);
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get ServicePointID value
     * @return int
     */
    public function getServicePointID()
    {
        return $this->ServicePointID;
    }
    /**
     * Set ServicePointID value
     * @param int $servicePointID
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setServicePointID($servicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointID) && !is_numeric($servicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointID)), __LINE__);
        }
        $this->ServicePointID = $servicePointID;
        return $this;
    }
    /**
     * Get InactivationDate value
     * @return string
     */
    public function getInactivationDate()
    {
        return $this->InactivationDate;
    }
    /**
     * Set InactivationDate value
     * @param string $inactivationDate
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setInactivationDate($inactivationDate = null)
    {
        // validation for constraint: string
        if (!is_null($inactivationDate) && !is_string($inactivationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inactivationDate)), __LINE__);
        }
        $this->InactivationDate = $inactivationDate;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get ServicePointStatusID value
     * @return int
     */
    public function getServicePointStatusID()
    {
        return $this->ServicePointStatusID;
    }
    /**
     * Set ServicePointStatusID value
     * @param int $servicePointStatusID
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setServicePointStatusID($servicePointStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointStatusID) && !is_numeric($servicePointStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointStatusID)), __LINE__);
        }
        $this->ServicePointStatusID = $servicePointStatusID;
        return $this;
    }
    /**
     * Get ServicePointMeterID value
     * @return int
     */
    public function getServicePointMeterID()
    {
        return $this->ServicePointMeterID;
    }
    /**
     * Set ServicePointMeterID value
     * @param int $servicePointMeterID
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setServicePointMeterID($servicePointMeterID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointMeterID) && !is_numeric($servicePointMeterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointMeterID)), __LINE__);
        }
        $this->ServicePointMeterID = $servicePointMeterID;
        return $this;
    }
    /**
     * Get ScheduledActionDate value
     * @return string
     */
    public function getScheduledActionDate()
    {
        return $this->ScheduledActionDate;
    }
    /**
     * Set ScheduledActionDate value
     * @param string $scheduledActionDate
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setScheduledActionDate($scheduledActionDate = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledActionDate) && !is_string($scheduledActionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledActionDate)), __LINE__);
        }
        $this->ScheduledActionDate = $scheduledActionDate;
        return $this;
    }
    /**
     * Get MeterID value
     * @return int
     */
    public function getMeterID()
    {
        return $this->MeterID;
    }
    /**
     * Set MeterID value
     * @param int $meterID
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setMeterID($meterID = null)
    {
        // validation for constraint: int
        if (!is_null($meterID) && !is_numeric($meterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterID)), __LINE__);
        }
        $this->MeterID = $meterID;
        return $this;
    }
    /**
     * Get MeterStatusID value
     * @return int
     */
    public function getMeterStatusID()
    {
        return $this->MeterStatusID;
    }
    /**
     * Set MeterStatusID value
     * @param int $meterStatusID
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setMeterStatusID($meterStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($meterStatusID) && !is_numeric($meterStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterStatusID)), __LINE__);
        }
        $this->MeterStatusID = $meterStatusID;
        return $this;
    }
    /**
     * Get IsEnergyAssistance value
     * @return bool
     */
    public function getIsEnergyAssistance()
    {
        return $this->IsEnergyAssistance;
    }
    /**
     * Set IsEnergyAssistance value
     * @param bool $isEnergyAssistance
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setIsEnergyAssistance($isEnergyAssistance = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnergyAssistance) && !is_bool($isEnergyAssistance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEnergyAssistance)), __LINE__);
        }
        $this->IsEnergyAssistance = $isEnergyAssistance;
        return $this;
    }
    /**
     * Get ServicePointStatusDate value
     * @return string
     */
    public function getServicePointStatusDate()
    {
        return $this->ServicePointStatusDate;
    }
    /**
     * Set ServicePointStatusDate value
     * @param string $servicePointStatusDate
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setServicePointStatusDate($servicePointStatusDate = null)
    {
        // validation for constraint: string
        if (!is_null($servicePointStatusDate) && !is_string($servicePointStatusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePointStatusDate)), __LINE__);
        }
        $this->ServicePointStatusDate = $servicePointStatusDate;
        return $this;
    }
    /**
     * Get DistributionPointID value
     * @return int
     */
    public function getDistributionPointID()
    {
        return $this->DistributionPointID;
    }
    /**
     * Set DistributionPointID value
     * @param int $distributionPointID
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setDistributionPointID($distributionPointID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionPointID) && !is_numeric($distributionPointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionPointID)), __LINE__);
        }
        $this->DistributionPointID = $distributionPointID;
        return $this;
    }
    /**
     * Get ServiceStartDate value
     * @return string
     */
    public function getServiceStartDate()
    {
        return $this->ServiceStartDate;
    }
    /**
     * Set ServiceStartDate value
     * @param string $serviceStartDate
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setServiceStartDate($serviceStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($serviceStartDate) && !is_string($serviceStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceStartDate)), __LINE__);
        }
        $this->ServiceStartDate = $serviceStartDate;
        return $this;
    }
    /**
     * Get PremiseTypeID value
     * @return int
     */
    public function getPremiseTypeID()
    {
        return $this->PremiseTypeID;
    }
    /**
     * Set PremiseTypeID value
     * @param int $premiseTypeID
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setPremiseTypeID($premiseTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($premiseTypeID) && !is_numeric($premiseTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($premiseTypeID)), __LINE__);
        }
        $this->PremiseTypeID = $premiseTypeID;
        return $this;
    }
    /**
     * Get IsBudgetBilling value
     * @return bool
     */
    public function getIsBudgetBilling()
    {
        return $this->IsBudgetBilling;
    }
    /**
     * Set IsBudgetBilling value
     * @param bool $isBudgetBilling
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setIsBudgetBilling($isBudgetBilling = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBudgetBilling) && !is_bool($isBudgetBilling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBudgetBilling)), __LINE__);
        }
        $this->IsBudgetBilling = $isBudgetBilling;
        return $this;
    }
    /**
     * Get BudgetBillMonths value
     * @return int
     */
    public function getBudgetBillMonths()
    {
        return $this->BudgetBillMonths;
    }
    /**
     * Set BudgetBillMonths value
     * @param int $budgetBillMonths
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setBudgetBillMonths($budgetBillMonths = null)
    {
        // validation for constraint: int
        if (!is_null($budgetBillMonths) && !is_numeric($budgetBillMonths)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($budgetBillMonths)), __LINE__);
        }
        $this->BudgetBillMonths = $budgetBillMonths;
        return $this;
    }
    /**
     * Get BudgetBillingTypeID value
     * @return int
     */
    public function getBudgetBillingTypeID()
    {
        return $this->BudgetBillingTypeID;
    }
    /**
     * Set BudgetBillingTypeID value
     * @param int $budgetBillingTypeID
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setBudgetBillingTypeID($budgetBillingTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($budgetBillingTypeID) && !is_numeric($budgetBillingTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($budgetBillingTypeID)), __LINE__);
        }
        $this->BudgetBillingTypeID = $budgetBillingTypeID;
        return $this;
    }
    /**
     * Get BudgetBillingTrueUpMonth value
     * @return int
     */
    public function getBudgetBillingTrueUpMonth()
    {
        return $this->BudgetBillingTrueUpMonth;
    }
    /**
     * Set BudgetBillingTrueUpMonth value
     * @param int $budgetBillingTrueUpMonth
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setBudgetBillingTrueUpMonth($budgetBillingTrueUpMonth = null)
    {
        // validation for constraint: int
        if (!is_null($budgetBillingTrueUpMonth) && !is_numeric($budgetBillingTrueUpMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($budgetBillingTrueUpMonth)), __LINE__);
        }
        $this->BudgetBillingTrueUpMonth = $budgetBillingTrueUpMonth;
        return $this;
    }
    /**
     * Get BudgetBillingStartDate value
     * @return string
     */
    public function getBudgetBillingStartDate()
    {
        return $this->BudgetBillingStartDate;
    }
    /**
     * Set BudgetBillingStartDate value
     * @param string $budgetBillingStartDate
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setBudgetBillingStartDate($budgetBillingStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($budgetBillingStartDate) && !is_string($budgetBillingStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($budgetBillingStartDate)), __LINE__);
        }
        $this->BudgetBillingStartDate = $budgetBillingStartDate;
        return $this;
    }
    /**
     * Get BudgetBillingTrueUpNextBill value
     * @return bool
     */
    public function getBudgetBillingTrueUpNextBill()
    {
        return $this->BudgetBillingTrueUpNextBill;
    }
    /**
     * Set BudgetBillingTrueUpNextBill value
     * @param bool $budgetBillingTrueUpNextBill
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setBudgetBillingTrueUpNextBill($budgetBillingTrueUpNextBill = null)
    {
        // validation for constraint: boolean
        if (!is_null($budgetBillingTrueUpNextBill) && !is_bool($budgetBillingTrueUpNextBill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($budgetBillingTrueUpNextBill)), __LINE__);
        }
        $this->BudgetBillingTrueUpNextBill = $budgetBillingTrueUpNextBill;
        return $this;
    }
    /**
     * Get StaticFlatBillAmountOnlyRead value
     * @return float
     */
    public function getStaticFlatBillAmountOnlyRead()
    {
        return $this->StaticFlatBillAmountOnlyRead;
    }
    /**
     * Set StaticFlatBillAmountOnlyRead value
     * @param float $staticFlatBillAmountOnlyRead
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setStaticFlatBillAmountOnlyRead($staticFlatBillAmountOnlyRead = null)
    {
        $this->StaticFlatBillAmountOnlyRead = $staticFlatBillAmountOnlyRead;
        return $this;
    }
    /**
     * Get LastDisconnectDate value
     * @return string
     */
    public function getLastDisconnectDate()
    {
        return $this->LastDisconnectDate;
    }
    /**
     * Set LastDisconnectDate value
     * @param string $lastDisconnectDate
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setLastDisconnectDate($lastDisconnectDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastDisconnectDate) && !is_string($lastDisconnectDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastDisconnectDate)), __LINE__);
        }
        $this->LastDisconnectDate = $lastDisconnectDate;
        return $this;
    }
    /**
     * Get LastReconnectDate value
     * @return string
     */
    public function getLastReconnectDate()
    {
        return $this->LastReconnectDate;
    }
    /**
     * Set LastReconnectDate value
     * @param string $lastReconnectDate
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setLastReconnectDate($lastReconnectDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastReconnectDate) && !is_string($lastReconnectDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastReconnectDate)), __LINE__);
        }
        $this->LastReconnectDate = $lastReconnectDate;
        return $this;
    }
    /**
     * Get IsSwitchHoldBillPay value
     * @return bool
     */
    public function getIsSwitchHoldBillPay()
    {
        return $this->IsSwitchHoldBillPay;
    }
    /**
     * Set IsSwitchHoldBillPay value
     * @param bool $isSwitchHoldBillPay
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setIsSwitchHoldBillPay($isSwitchHoldBillPay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSwitchHoldBillPay) && !is_bool($isSwitchHoldBillPay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSwitchHoldBillPay)), __LINE__);
        }
        $this->IsSwitchHoldBillPay = $isSwitchHoldBillPay;
        return $this;
    }
    /**
     * Get IsSwitchHoldTampering value
     * @return bool
     */
    public function getIsSwitchHoldTampering()
    {
        return $this->IsSwitchHoldTampering;
    }
    /**
     * Set IsSwitchHoldTampering value
     * @param bool $isSwitchHoldTampering
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setIsSwitchHoldTampering($isSwitchHoldTampering = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSwitchHoldTampering) && !is_bool($isSwitchHoldTampering)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSwitchHoldTampering)), __LINE__);
        }
        $this->IsSwitchHoldTampering = $isSwitchHoldTampering;
        return $this;
    }
    /**
     * Get IsCriticalCare value
     * @return bool
     */
    public function getIsCriticalCare()
    {
        return $this->IsCriticalCare;
    }
    /**
     * Set IsCriticalCare value
     * @param bool $isCriticalCare
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setIsCriticalCare($isCriticalCare = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCriticalCare) && !is_bool($isCriticalCare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCriticalCare)), __LINE__);
        }
        $this->IsCriticalCare = $isCriticalCare;
        return $this;
    }
    /**
     * Get IsTransfer value
     * @return bool
     */
    public function getIsTransfer()
    {
        return $this->IsTransfer;
    }
    /**
     * Set IsTransfer value
     * @param bool $isTransfer
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setIsTransfer($isTransfer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTransfer) && !is_bool($isTransfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTransfer)), __LINE__);
        }
        $this->IsTransfer = $isTransfer;
        return $this;
    }
    /**
     * Get TransferredFrom value
     * @return int
     */
    public function getTransferredFrom()
    {
        return $this->TransferredFrom;
    }
    /**
     * Set TransferredFrom value
     * @param int $transferredFrom
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setTransferredFrom($transferredFrom = null)
    {
        // validation for constraint: int
        if (!is_null($transferredFrom) && !is_numeric($transferredFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transferredFrom)), __LINE__);
        }
        $this->TransferredFrom = $transferredFrom;
        return $this;
    }
    /**
     * Get TransferredTo value
     * @return int
     */
    public function getTransferredTo()
    {
        return $this->TransferredTo;
    }
    /**
     * Set TransferredTo value
     * @param int $transferredTo
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setTransferredTo($transferredTo = null)
    {
        // validation for constraint: int
        if (!is_null($transferredTo) && !is_numeric($transferredTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transferredTo)), __LINE__);
        }
        $this->TransferredTo = $transferredTo;
        return $this;
    }
    /**
     * Get ThirdPartyVerificationID value
     * @return int
     */
    public function getThirdPartyVerificationID()
    {
        return $this->ThirdPartyVerificationID;
    }
    /**
     * Set ThirdPartyVerificationID value
     * @param int $thirdPartyVerificationID
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setThirdPartyVerificationID($thirdPartyVerificationID = null)
    {
        // validation for constraint: int
        if (!is_null($thirdPartyVerificationID) && !is_numeric($thirdPartyVerificationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($thirdPartyVerificationID)), __LINE__);
        }
        $this->ThirdPartyVerificationID = $thirdPartyVerificationID;
        return $this;
    }
    /**
     * Get BillThisAccountServicePoint value
     * @return bool
     */
    public function getBillThisAccountServicePoint()
    {
        return $this->BillThisAccountServicePoint;
    }
    /**
     * Set BillThisAccountServicePoint value
     * @param bool $billThisAccountServicePoint
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setBillThisAccountServicePoint($billThisAccountServicePoint = null)
    {
        // validation for constraint: boolean
        if (!is_null($billThisAccountServicePoint) && !is_bool($billThisAccountServicePoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($billThisAccountServicePoint)), __LINE__);
        }
        $this->BillThisAccountServicePoint = $billThisAccountServicePoint;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get BillingCycle value
     * @return string|null
     */
    public function getBillingCycle()
    {
        return $this->BillingCycle;
    }
    /**
     * Set BillingCycle value
     * @param string $billingCycle
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setBillingCycle($billingCycle = null)
    {
        // validation for constraint: string
        if (!is_null($billingCycle) && !is_string($billingCycle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCycle)), __LINE__);
        }
        $this->BillingCycle = $billingCycle;
        return $this;
    }
    /**
     * Get ServiceProviderIdentifier value
     * @return string|null
     */
    public function getServiceProviderIdentifier()
    {
        return $this->ServiceProviderIdentifier;
    }
    /**
     * Set ServiceProviderIdentifier value
     * @param string $serviceProviderIdentifier
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setServiceProviderIdentifier($serviceProviderIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderIdentifier) && !is_string($serviceProviderIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderIdentifier)), __LINE__);
        }
        $this->ServiceProviderIdentifier = $serviceProviderIdentifier;
        return $this;
    }
    /**
     * Get MeterSerialNumber value
     * @return string|null
     */
    public function getMeterSerialNumber()
    {
        return $this->MeterSerialNumber;
    }
    /**
     * Set MeterSerialNumber value
     * @param string $meterSerialNumber
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setMeterSerialNumber($meterSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($meterSerialNumber) && !is_string($meterSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterSerialNumber)), __LINE__);
        }
        $this->MeterSerialNumber = $meterSerialNumber;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxCode)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get ServicePointMeters value
     * @return \SGCIS\Array\ArrayOfServicePointMeter|null
     */
    public function getServicePointMeters()
    {
        return $this->ServicePointMeters;
    }
    /**
     * Set ServicePointMeters value
     * @param \SGCIS\Array\ArrayOfServicePointMeter $servicePointMeters
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setServicePointMeters(\SGCIS\Array\ArrayOfServicePointMeter $servicePointMeters = null)
    {
        $this->ServicePointMeters = $servicePointMeters;
        return $this;
    }
    /**
     * Get ServicePoint value
     * @return \SGCIS\Struct\ServicePoint|null
     */
    public function getServicePoint()
    {
        return $this->ServicePoint;
    }
    /**
     * Set ServicePoint value
     * @param \SGCIS\Struct\ServicePoint $servicePoint
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setServicePoint(\SGCIS\Struct\ServicePoint $servicePoint = null)
    {
        $this->ServicePoint = $servicePoint;
        return $this;
    }
    /**
     * Get ServiceAgreements value
     * @return \SGCIS\Array\ArrayOfServiceAgreement|null
     */
    public function getServiceAgreements()
    {
        return $this->ServiceAgreements;
    }
    /**
     * Set ServiceAgreements value
     * @param \SGCIS\Array\ArrayOfServiceAgreement $serviceAgreements
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setServiceAgreements(\SGCIS\Array\ArrayOfServiceAgreement $serviceAgreements = null)
    {
        $this->ServiceAgreements = $serviceAgreements;
        return $this;
    }
    /**
     * Get AccountServicePointCharges value
     * @return \SGCIS\Array\ArrayOfAccountServicePointTarrifCharge|null
     */
    public function getAccountServicePointCharges()
    {
        return $this->AccountServicePointCharges;
    }
    /**
     * Set AccountServicePointCharges value
     * @param \SGCIS\Array\ArrayOfAccountServicePointTarrifCharge $accountServicePointCharges
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setAccountServicePointCharges(\SGCIS\Array\ArrayOfAccountServicePointTarrifCharge $accountServicePointCharges = null)
    {
        $this->AccountServicePointCharges = $accountServicePointCharges;
        return $this;
    }
    /**
     * Get Rate value
     * @return \SGCIS\Struct\Rate|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param \SGCIS\Struct\Rate $rate
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setRate(\SGCIS\Struct\Rate $rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get LegacySystem value
     * @return string|null
     */
    public function getLegacySystem()
    {
        return $this->LegacySystem;
    }
    /**
     * Set LegacySystem value
     * @param string $legacySystem
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setLegacySystem($legacySystem = null)
    {
        // validation for constraint: string
        if (!is_null($legacySystem) && !is_string($legacySystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($legacySystem)), __LINE__);
        }
        $this->LegacySystem = $legacySystem;
        return $this;
    }
    /**
     * Get ThirdPartyVerificationName value
     * @return string|null
     */
    public function getThirdPartyVerificationName()
    {
        return $this->ThirdPartyVerificationName;
    }
    /**
     * Set ThirdPartyVerificationName value
     * @param string $thirdPartyVerificationName
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setThirdPartyVerificationName($thirdPartyVerificationName = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyVerificationName) && !is_string($thirdPartyVerificationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($thirdPartyVerificationName)), __LINE__);
        }
        $this->ThirdPartyVerificationName = $thirdPartyVerificationName;
        return $this;
    }
    /**
     * Get Product value
     * @return \SGCIS\Struct\Product|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \SGCIS\Struct\Product $product
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public function setProduct(\SGCIS\Struct\Product $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountServicePoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
