<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountResponse Struct
 * @subpackage Structs
 */
class AccountResponse extends ServiceResponseBase
{
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Account
     */
    public $Account;
    /**
     * The AccountDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountDocument
     */
    public $AccountDocument;
    /**
     * The AccountDocuments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountDocument
     */
    public $AccountDocuments;
    /**
     * The AccountSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountSummary
     */
    public $AccountSummary;
    /**
     * The AccountHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountStatusHistory
     */
    public $AccountHistory;
    /**
     * The AccountCommunications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountCommunication
     */
    public $AccountCommunications;
    /**
     * The Tickets
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTicket
     */
    public $Tickets;
    /**
     * The ServiceOrders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServiceOrder
     */
    public $ServiceOrders;
    /**
     * The AuditLog
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAuditLog
     */
    public $AuditLog;
    /**
     * Constructor method for AccountResponse
     * @uses AccountResponse::setAccount()
     * @uses AccountResponse::setAccountDocument()
     * @uses AccountResponse::setAccountDocuments()
     * @uses AccountResponse::setAccountSummary()
     * @uses AccountResponse::setAccountHistory()
     * @uses AccountResponse::setAccountCommunications()
     * @uses AccountResponse::setTickets()
     * @uses AccountResponse::setServiceOrders()
     * @uses AccountResponse::setAuditLog()
     * @param \SGCIS\Struct\Account $account
     * @param \SGCIS\Struct\AccountDocument $accountDocument
     * @param \SGCIS\Array\ArrayOfAccountDocument $accountDocuments
     * @param \SGCIS\Struct\AccountSummary $accountSummary
     * @param \SGCIS\Array\ArrayOfAccountStatusHistory $accountHistory
     * @param \SGCIS\Array\ArrayOfAccountCommunication $accountCommunications
     * @param \SGCIS\Array\ArrayOfTicket $tickets
     * @param \SGCIS\Array\ArrayOfServiceOrder $serviceOrders
     * @param \SGCIS\Array\ArrayOfAuditLog $auditLog
     */
    public function __construct(\SGCIS\Struct\Account $account = null, \SGCIS\Struct\AccountDocument $accountDocument = null, \SGCIS\Array\ArrayOfAccountDocument $accountDocuments = null, \SGCIS\Struct\AccountSummary $accountSummary = null, \SGCIS\Array\ArrayOfAccountStatusHistory $accountHistory = null, \SGCIS\Array\ArrayOfAccountCommunication $accountCommunications = null, \SGCIS\Array\ArrayOfTicket $tickets = null, \SGCIS\Array\ArrayOfServiceOrder $serviceOrders = null, \SGCIS\Array\ArrayOfAuditLog $auditLog = null)
    {
        $this
            ->setAccount($account)
            ->setAccountDocument($accountDocument)
            ->setAccountDocuments($accountDocuments)
            ->setAccountSummary($accountSummary)
            ->setAccountHistory($accountHistory)
            ->setAccountCommunications($accountCommunications)
            ->setTickets($tickets)
            ->setServiceOrders($serviceOrders)
            ->setAuditLog($auditLog);
    }
    /**
     * Get Account value
     * @return \SGCIS\Struct\Account|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \SGCIS\Struct\Account $account
     * @return \SGCIS\Struct\AccountResponse
     */
    public function setAccount(\SGCIS\Struct\Account $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get AccountDocument value
     * @return \SGCIS\Struct\AccountDocument|null
     */
    public function getAccountDocument()
    {
        return $this->AccountDocument;
    }
    /**
     * Set AccountDocument value
     * @param \SGCIS\Struct\AccountDocument $accountDocument
     * @return \SGCIS\Struct\AccountResponse
     */
    public function setAccountDocument(\SGCIS\Struct\AccountDocument $accountDocument = null)
    {
        $this->AccountDocument = $accountDocument;
        return $this;
    }
    /**
     * Get AccountDocuments value
     * @return \SGCIS\Array\ArrayOfAccountDocument|null
     */
    public function getAccountDocuments()
    {
        return $this->AccountDocuments;
    }
    /**
     * Set AccountDocuments value
     * @param \SGCIS\Array\ArrayOfAccountDocument $accountDocuments
     * @return \SGCIS\Struct\AccountResponse
     */
    public function setAccountDocuments(\SGCIS\Array\ArrayOfAccountDocument $accountDocuments = null)
    {
        $this->AccountDocuments = $accountDocuments;
        return $this;
    }
    /**
     * Get AccountSummary value
     * @return \SGCIS\Struct\AccountSummary|null
     */
    public function getAccountSummary()
    {
        return $this->AccountSummary;
    }
    /**
     * Set AccountSummary value
     * @param \SGCIS\Struct\AccountSummary $accountSummary
     * @return \SGCIS\Struct\AccountResponse
     */
    public function setAccountSummary(\SGCIS\Struct\AccountSummary $accountSummary = null)
    {
        $this->AccountSummary = $accountSummary;
        return $this;
    }
    /**
     * Get AccountHistory value
     * @return \SGCIS\Array\ArrayOfAccountStatusHistory|null
     */
    public function getAccountHistory()
    {
        return $this->AccountHistory;
    }
    /**
     * Set AccountHistory value
     * @param \SGCIS\Array\ArrayOfAccountStatusHistory $accountHistory
     * @return \SGCIS\Struct\AccountResponse
     */
    public function setAccountHistory(\SGCIS\Array\ArrayOfAccountStatusHistory $accountHistory = null)
    {
        $this->AccountHistory = $accountHistory;
        return $this;
    }
    /**
     * Get AccountCommunications value
     * @return \SGCIS\Array\ArrayOfAccountCommunication|null
     */
    public function getAccountCommunications()
    {
        return $this->AccountCommunications;
    }
    /**
     * Set AccountCommunications value
     * @param \SGCIS\Array\ArrayOfAccountCommunication $accountCommunications
     * @return \SGCIS\Struct\AccountResponse
     */
    public function setAccountCommunications(\SGCIS\Array\ArrayOfAccountCommunication $accountCommunications = null)
    {
        $this->AccountCommunications = $accountCommunications;
        return $this;
    }
    /**
     * Get Tickets value
     * @return \SGCIS\Array\ArrayOfTicket|null
     */
    public function getTickets()
    {
        return $this->Tickets;
    }
    /**
     * Set Tickets value
     * @param \SGCIS\Array\ArrayOfTicket $tickets
     * @return \SGCIS\Struct\AccountResponse
     */
    public function setTickets(\SGCIS\Array\ArrayOfTicket $tickets = null)
    {
        $this->Tickets = $tickets;
        return $this;
    }
    /**
     * Get ServiceOrders value
     * @return \SGCIS\Array\ArrayOfServiceOrder|null
     */
    public function getServiceOrders()
    {
        return $this->ServiceOrders;
    }
    /**
     * Set ServiceOrders value
     * @param \SGCIS\Array\ArrayOfServiceOrder $serviceOrders
     * @return \SGCIS\Struct\AccountResponse
     */
    public function setServiceOrders(\SGCIS\Array\ArrayOfServiceOrder $serviceOrders = null)
    {
        $this->ServiceOrders = $serviceOrders;
        return $this;
    }
    /**
     * Get AuditLog value
     * @return \SGCIS\Array\ArrayOfAuditLog|null
     */
    public function getAuditLog()
    {
        return $this->AuditLog;
    }
    /**
     * Set AuditLog value
     * @param \SGCIS\Array\ArrayOfAuditLog $auditLog
     * @return \SGCIS\Struct\AccountResponse
     */
    public function setAuditLog(\SGCIS\Array\ArrayOfAuditLog $auditLog = null)
    {
        $this->AuditLog = $auditLog;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
