<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountPerson Struct
 * @subpackage Structs
 */
class AccountPerson extends BaseDTO
{
    /**
     * The AccountPersonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountPersonID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The PersonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonID;
    /**
     * The IsPrimary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPrimary;
    /**
     * The MatchCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MatchCount;
    /**
     * The IsESIIDMatch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsESIIDMatch;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * Constructor method for AccountPerson
     * @uses AccountPerson::setAccountPersonID()
     * @uses AccountPerson::setAccountID()
     * @uses AccountPerson::setPersonID()
     * @uses AccountPerson::setIsPrimary()
     * @uses AccountPerson::setMatchCount()
     * @uses AccountPerson::setIsESIIDMatch()
     * @uses AccountPerson::setAccountNumber()
     * @param int $accountPersonID
     * @param int $accountID
     * @param int $personID
     * @param bool $isPrimary
     * @param int $matchCount
     * @param bool $isESIIDMatch
     * @param string $accountNumber
     */
    public function __construct($accountPersonID = null, $accountID = null, $personID = null, $isPrimary = null, $matchCount = null, $isESIIDMatch = null, $accountNumber = null)
    {
        $this
            ->setAccountPersonID($accountPersonID)
            ->setAccountID($accountID)
            ->setPersonID($personID)
            ->setIsPrimary($isPrimary)
            ->setMatchCount($matchCount)
            ->setIsESIIDMatch($isESIIDMatch)
            ->setAccountNumber($accountNumber);
    }
    /**
     * Get AccountPersonID value
     * @return int
     */
    public function getAccountPersonID()
    {
        return $this->AccountPersonID;
    }
    /**
     * Set AccountPersonID value
     * @param int $accountPersonID
     * @return \SGCIS\Struct\AccountPerson
     */
    public function setAccountPersonID($accountPersonID = null)
    {
        // validation for constraint: int
        if (!is_null($accountPersonID) && !is_numeric($accountPersonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountPersonID)), __LINE__);
        }
        $this->AccountPersonID = $accountPersonID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountPerson
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get PersonID value
     * @return int
     */
    public function getPersonID()
    {
        return $this->PersonID;
    }
    /**
     * Set PersonID value
     * @param int $personID
     * @return \SGCIS\Struct\AccountPerson
     */
    public function setPersonID($personID = null)
    {
        // validation for constraint: int
        if (!is_null($personID) && !is_numeric($personID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personID)), __LINE__);
        }
        $this->PersonID = $personID;
        return $this;
    }
    /**
     * Get IsPrimary value
     * @return bool
     */
    public function getIsPrimary()
    {
        return $this->IsPrimary;
    }
    /**
     * Set IsPrimary value
     * @param bool $isPrimary
     * @return \SGCIS\Struct\AccountPerson
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimary) && !is_bool($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPrimary)), __LINE__);
        }
        $this->IsPrimary = $isPrimary;
        return $this;
    }
    /**
     * Get MatchCount value
     * @return int
     */
    public function getMatchCount()
    {
        return $this->MatchCount;
    }
    /**
     * Set MatchCount value
     * @param int $matchCount
     * @return \SGCIS\Struct\AccountPerson
     */
    public function setMatchCount($matchCount = null)
    {
        // validation for constraint: int
        if (!is_null($matchCount) && !is_numeric($matchCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($matchCount)), __LINE__);
        }
        $this->MatchCount = $matchCount;
        return $this;
    }
    /**
     * Get IsESIIDMatch value
     * @return bool
     */
    public function getIsESIIDMatch()
    {
        return $this->IsESIIDMatch;
    }
    /**
     * Set IsESIIDMatch value
     * @param bool $isESIIDMatch
     * @return \SGCIS\Struct\AccountPerson
     */
    public function setIsESIIDMatch($isESIIDMatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($isESIIDMatch) && !is_bool($isESIIDMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isESIIDMatch)), __LINE__);
        }
        $this->IsESIIDMatch = $isESIIDMatch;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\AccountPerson
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountPerson
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
