<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDepositSchedule Struct
 * @subpackage Structs
 */
class AccountDepositSchedule extends BaseDTO
{
    /**
     * The AccountDepositScheduleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountDepositScheduleID;
    /**
     * The AccountDepositID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountDepositID;
    /**
     * The AmountDue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountDue;
    /**
     * The PaymentDueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentDueDate;
    /**
     * The InstallmentNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InstallmentNumber;
    /**
     * The PaymentProcessed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PaymentProcessed;
    /**
     * The PaymentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentDate;
    /**
     * The RequiredToStart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RequiredToStart;
    /**
     * The BalanceAfterPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BalanceAfterPayment;
    /**
     * The PaymentAmountReceived
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PaymentAmountReceived;
    /**
     * The ScheduleToAccelerate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ScheduleToAccelerate;
    /**
     * The SystemNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemNotes;
    /**
     * The AccountDepositScheduleGuid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountDepositScheduleGuid;
    /**
     * The ServiceProviderIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderIdentifier;
    /**
     * Constructor method for AccountDepositSchedule
     * @uses AccountDepositSchedule::setAccountDepositScheduleID()
     * @uses AccountDepositSchedule::setAccountDepositID()
     * @uses AccountDepositSchedule::setAmountDue()
     * @uses AccountDepositSchedule::setPaymentDueDate()
     * @uses AccountDepositSchedule::setInstallmentNumber()
     * @uses AccountDepositSchedule::setPaymentProcessed()
     * @uses AccountDepositSchedule::setPaymentDate()
     * @uses AccountDepositSchedule::setRequiredToStart()
     * @uses AccountDepositSchedule::setBalanceAfterPayment()
     * @uses AccountDepositSchedule::setPaymentAmountReceived()
     * @uses AccountDepositSchedule::setScheduleToAccelerate()
     * @uses AccountDepositSchedule::setSystemNotes()
     * @uses AccountDepositSchedule::setAccountDepositScheduleGuid()
     * @uses AccountDepositSchedule::setServiceProviderIdentifier()
     * @param int $accountDepositScheduleID
     * @param int $accountDepositID
     * @param float $amountDue
     * @param string $paymentDueDate
     * @param int $installmentNumber
     * @param bool $paymentProcessed
     * @param string $paymentDate
     * @param bool $requiredToStart
     * @param float $balanceAfterPayment
     * @param float $paymentAmountReceived
     * @param bool $scheduleToAccelerate
     * @param string $systemNotes
     * @param string $accountDepositScheduleGuid
     * @param string $serviceProviderIdentifier
     */
    public function __construct($accountDepositScheduleID = null, $accountDepositID = null, $amountDue = null, $paymentDueDate = null, $installmentNumber = null, $paymentProcessed = null, $paymentDate = null, $requiredToStart = null, $balanceAfterPayment = null, $paymentAmountReceived = null, $scheduleToAccelerate = null, $systemNotes = null, $accountDepositScheduleGuid = null, $serviceProviderIdentifier = null)
    {
        $this
            ->setAccountDepositScheduleID($accountDepositScheduleID)
            ->setAccountDepositID($accountDepositID)
            ->setAmountDue($amountDue)
            ->setPaymentDueDate($paymentDueDate)
            ->setInstallmentNumber($installmentNumber)
            ->setPaymentProcessed($paymentProcessed)
            ->setPaymentDate($paymentDate)
            ->setRequiredToStart($requiredToStart)
            ->setBalanceAfterPayment($balanceAfterPayment)
            ->setPaymentAmountReceived($paymentAmountReceived)
            ->setScheduleToAccelerate($scheduleToAccelerate)
            ->setSystemNotes($systemNotes)
            ->setAccountDepositScheduleGuid($accountDepositScheduleGuid)
            ->setServiceProviderIdentifier($serviceProviderIdentifier);
    }
    /**
     * Get AccountDepositScheduleID value
     * @return int
     */
    public function getAccountDepositScheduleID()
    {
        return $this->AccountDepositScheduleID;
    }
    /**
     * Set AccountDepositScheduleID value
     * @param int $accountDepositScheduleID
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public function setAccountDepositScheduleID($accountDepositScheduleID = null)
    {
        // validation for constraint: int
        if (!is_null($accountDepositScheduleID) && !is_numeric($accountDepositScheduleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountDepositScheduleID)), __LINE__);
        }
        $this->AccountDepositScheduleID = $accountDepositScheduleID;
        return $this;
    }
    /**
     * Get AccountDepositID value
     * @return int
     */
    public function getAccountDepositID()
    {
        return $this->AccountDepositID;
    }
    /**
     * Set AccountDepositID value
     * @param int $accountDepositID
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public function setAccountDepositID($accountDepositID = null)
    {
        // validation for constraint: int
        if (!is_null($accountDepositID) && !is_numeric($accountDepositID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountDepositID)), __LINE__);
        }
        $this->AccountDepositID = $accountDepositID;
        return $this;
    }
    /**
     * Get AmountDue value
     * @return float
     */
    public function getAmountDue()
    {
        return $this->AmountDue;
    }
    /**
     * Set AmountDue value
     * @param float $amountDue
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public function setAmountDue($amountDue = null)
    {
        $this->AmountDue = $amountDue;
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return string
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param string $paymentDueDate
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public function setPaymentDueDate($paymentDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDueDate) && !is_string($paymentDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDueDate)), __LINE__);
        }
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get InstallmentNumber value
     * @return int
     */
    public function getInstallmentNumber()
    {
        return $this->InstallmentNumber;
    }
    /**
     * Set InstallmentNumber value
     * @param int $installmentNumber
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public function setInstallmentNumber($installmentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($installmentNumber) && !is_numeric($installmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($installmentNumber)), __LINE__);
        }
        $this->InstallmentNumber = $installmentNumber;
        return $this;
    }
    /**
     * Get PaymentProcessed value
     * @return bool
     */
    public function getPaymentProcessed()
    {
        return $this->PaymentProcessed;
    }
    /**
     * Set PaymentProcessed value
     * @param bool $paymentProcessed
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public function setPaymentProcessed($paymentProcessed = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentProcessed) && !is_bool($paymentProcessed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($paymentProcessed)), __LINE__);
        }
        $this->PaymentProcessed = $paymentProcessed;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get RequiredToStart value
     * @return bool
     */
    public function getRequiredToStart()
    {
        return $this->RequiredToStart;
    }
    /**
     * Set RequiredToStart value
     * @param bool $requiredToStart
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public function setRequiredToStart($requiredToStart = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiredToStart) && !is_bool($requiredToStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requiredToStart)), __LINE__);
        }
        $this->RequiredToStart = $requiredToStart;
        return $this;
    }
    /**
     * Get BalanceAfterPayment value
     * @return float
     */
    public function getBalanceAfterPayment()
    {
        return $this->BalanceAfterPayment;
    }
    /**
     * Set BalanceAfterPayment value
     * @param float $balanceAfterPayment
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public function setBalanceAfterPayment($balanceAfterPayment = null)
    {
        $this->BalanceAfterPayment = $balanceAfterPayment;
        return $this;
    }
    /**
     * Get PaymentAmountReceived value
     * @return float
     */
    public function getPaymentAmountReceived()
    {
        return $this->PaymentAmountReceived;
    }
    /**
     * Set PaymentAmountReceived value
     * @param float $paymentAmountReceived
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public function setPaymentAmountReceived($paymentAmountReceived = null)
    {
        $this->PaymentAmountReceived = $paymentAmountReceived;
        return $this;
    }
    /**
     * Get ScheduleToAccelerate value
     * @return bool
     */
    public function getScheduleToAccelerate()
    {
        return $this->ScheduleToAccelerate;
    }
    /**
     * Set ScheduleToAccelerate value
     * @param bool $scheduleToAccelerate
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public function setScheduleToAccelerate($scheduleToAccelerate = null)
    {
        // validation for constraint: boolean
        if (!is_null($scheduleToAccelerate) && !is_bool($scheduleToAccelerate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($scheduleToAccelerate)), __LINE__);
        }
        $this->ScheduleToAccelerate = $scheduleToAccelerate;
        return $this;
    }
    /**
     * Get SystemNotes value
     * @return string|null
     */
    public function getSystemNotes()
    {
        return $this->SystemNotes;
    }
    /**
     * Set SystemNotes value
     * @param string $systemNotes
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public function setSystemNotes($systemNotes = null)
    {
        // validation for constraint: string
        if (!is_null($systemNotes) && !is_string($systemNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemNotes)), __LINE__);
        }
        $this->SystemNotes = $systemNotes;
        return $this;
    }
    /**
     * Get AccountDepositScheduleGuid value
     * @return string|null
     */
    public function getAccountDepositScheduleGuid()
    {
        return $this->AccountDepositScheduleGuid;
    }
    /**
     * Set AccountDepositScheduleGuid value
     * @param string $accountDepositScheduleGuid
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public function setAccountDepositScheduleGuid($accountDepositScheduleGuid = null)
    {
        // validation for constraint: string
        if (!is_null($accountDepositScheduleGuid) && !is_string($accountDepositScheduleGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountDepositScheduleGuid)), __LINE__);
        }
        $this->AccountDepositScheduleGuid = $accountDepositScheduleGuid;
        return $this;
    }
    /**
     * Get ServiceProviderIdentifier value
     * @return string|null
     */
    public function getServiceProviderIdentifier()
    {
        return $this->ServiceProviderIdentifier;
    }
    /**
     * Set ServiceProviderIdentifier value
     * @param string $serviceProviderIdentifier
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public function setServiceProviderIdentifier($serviceProviderIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderIdentifier) && !is_string($serviceProviderIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderIdentifier)), __LINE__);
        }
        $this->ServiceProviderIdentifier = $serviceProviderIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountDepositSchedule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
