<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountCustomField Struct
 * @subpackage Structs
 */
class AccountCustomField extends AbstractStructBase
{
    /**
     * The AccountCustomFieldID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountCustomFieldID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The CustomFieldID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomFieldID;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for AccountCustomField
     * @uses AccountCustomField::setAccountCustomFieldID()
     * @uses AccountCustomField::setAccountID()
     * @uses AccountCustomField::setCustomFieldID()
     * @uses AccountCustomField::setValue()
     * @param int $accountCustomFieldID
     * @param int $accountID
     * @param int $customFieldID
     * @param string $value
     */
    public function __construct($accountCustomFieldID = null, $accountID = null, $customFieldID = null, $value = null)
    {
        $this
            ->setAccountCustomFieldID($accountCustomFieldID)
            ->setAccountID($accountID)
            ->setCustomFieldID($customFieldID)
            ->setValue($value);
    }
    /**
     * Get AccountCustomFieldID value
     * @return int
     */
    public function getAccountCustomFieldID()
    {
        return $this->AccountCustomFieldID;
    }
    /**
     * Set AccountCustomFieldID value
     * @param int $accountCustomFieldID
     * @return \SGCIS\Struct\AccountCustomField
     */
    public function setAccountCustomFieldID($accountCustomFieldID = null)
    {
        // validation for constraint: int
        if (!is_null($accountCustomFieldID) && !is_numeric($accountCustomFieldID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountCustomFieldID)), __LINE__);
        }
        $this->AccountCustomFieldID = $accountCustomFieldID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountCustomField
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get CustomFieldID value
     * @return int
     */
    public function getCustomFieldID()
    {
        return $this->CustomFieldID;
    }
    /**
     * Set CustomFieldID value
     * @param int $customFieldID
     * @return \SGCIS\Struct\AccountCustomField
     */
    public function setCustomFieldID($customFieldID = null)
    {
        // validation for constraint: int
        if (!is_null($customFieldID) && !is_numeric($customFieldID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customFieldID)), __LINE__);
        }
        $this->CustomFieldID = $customFieldID;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \SGCIS\Struct\AccountCustomField
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountCustomField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
