<?php

namespace SGCIS\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Valid Service
 * @subpackage Services
 */
class Valid extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ValidPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ValidPhone $parameters
     * @return \SGCIS\Struct\ValidPhoneResponse|bool
     */
    public function ValidPhone(\SGCIS\Struct\ValidPhone $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ValidPhone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \SGCIS\Struct\ValidPhoneResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
