<?php

namespace SGCIS\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Register Service
 * @subpackage Services
 */
class Register extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RegisterCustomerWith2FactorAuth
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\RegisterCustomerWith2FactorAuth $parameters
     * @return \SGCIS\Struct\RegisterCustomerWith2FactorAuthResponse|bool
     */
    public function RegisterCustomerWith2FactorAuth(\SGCIS\Struct\RegisterCustomerWith2FactorAuth $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RegisterCustomerWith2FactorAuth($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Register
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\Register $parameters
     * @return \SGCIS\Struct\RegisterResponse|bool
     */
    public function Register(\SGCIS\Struct\Register $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Register($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \SGCIS\Struct\RegisterCustomerWith2FactorAuthResponse|\SGCIS\Struct\RegisterResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
