<?php

namespace SGCIS\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process Service
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProcessAccountEnrollment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ProcessAccountEnrollment $parameters
     * @return \SGCIS\Struct\ProcessAccountEnrollmentResponse|bool
     */
    public function ProcessAccountEnrollment(\SGCIS\Struct\ProcessAccountEnrollment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessAccountEnrollment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessAccountPayLater
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ProcessAccountPayLater $parameters
     * @return \SGCIS\Struct\ProcessAccountPayLaterResponse|bool
     */
    public function ProcessAccountPayLater(\SGCIS\Struct\ProcessAccountPayLater $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessAccountPayLater($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ProcessAccountTransferServiceLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ProcessAccountTransferServiceLocation $parameters
     * @return \SGCIS\Struct\ProcessAccountTransferServiceLocationResponse|bool
     */
    public function ProcessAccountTransferServiceLocation(\SGCIS\Struct\ProcessAccountTransferServiceLocation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessAccountTransferServiceLocation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \SGCIS\Struct\ProcessAccountEnrollmentResponse|\SGCIS\Struct\ProcessAccountPayLaterResponse|\SGCIS\Struct\ProcessAccountTransferServiceLocationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
