<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTicketTypeQueue Array
 * @subpackage Arrays
 */
class ArrayOfTicketTypeQueue extends AbstractStructArrayBase
{
    /**
     * The TicketTypeQueue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\TicketTypeQueue[]
     */
    public $TicketTypeQueue;
    /**
     * Constructor method for ArrayOfTicketTypeQueue
     * @uses ArrayOfTicketTypeQueue::setTicketTypeQueue()
     * @param \SGCIS\Struct\TicketTypeQueue[] $ticketTypeQueue
     */
    public function __construct(array $ticketTypeQueue = array())
    {
        $this
            ->setTicketTypeQueue($ticketTypeQueue);
    }
    /**
     * Get TicketTypeQueue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\TicketTypeQueue[]|null
     */
    public function getTicketTypeQueue()
    {
        return isset($this->TicketTypeQueue) ? $this->TicketTypeQueue : null;
    }
    /**
     * Set TicketTypeQueue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\TicketTypeQueue[] $ticketTypeQueue
     * @return \SGCIS\Array\ArrayOfTicketTypeQueue
     */
    public function setTicketTypeQueue(array $ticketTypeQueue = array())
    {
        foreach ($ticketTypeQueue as $arrayOfTicketTypeQueueTicketTypeQueueItem) {
            // validation for constraint: itemType
            if (!$arrayOfTicketTypeQueueTicketTypeQueueItem instanceof \SGCIS\Struct\TicketTypeQueue) {
                throw new \InvalidArgumentException(sprintf('The TicketTypeQueue property can only contain items of \SGCIS\Struct\TicketTypeQueue, "%s" given', is_object($arrayOfTicketTypeQueueTicketTypeQueueItem) ? get_class($arrayOfTicketTypeQueueTicketTypeQueueItem) : gettype($arrayOfTicketTypeQueueTicketTypeQueueItem)), __LINE__);
            }
        }
        if (is_null($ticketTypeQueue) || (is_array($ticketTypeQueue) && empty($ticketTypeQueue))) {
            unset($this->TicketTypeQueue);
        } else {
            $this->TicketTypeQueue = $ticketTypeQueue;
        }
        return $this;
    }
    /**
     * Add item to TicketTypeQueue value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\TicketTypeQueue $item
     * @return \SGCIS\Array\ArrayOfTicketTypeQueue
     */
    public function addToTicketTypeQueue(\SGCIS\Struct\TicketTypeQueue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\TicketTypeQueue) {
            throw new \InvalidArgumentException(sprintf('The TicketTypeQueue property can only contain items of \SGCIS\Struct\TicketTypeQueue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketTypeQueue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\TicketTypeQueue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\TicketTypeQueue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\TicketTypeQueue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\TicketTypeQueue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\TicketTypeQueue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TicketTypeQueue
     */
    public function getAttributeName()
    {
        return 'TicketTypeQueue';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfTicketTypeQueue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
