<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTicketNote Array
 * @subpackage Arrays
 */
class ArrayOfTicketNote extends AbstractStructArrayBase
{
    /**
     * The TicketNote
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\TicketNote[]
     */
    public $TicketNote;
    /**
     * Constructor method for ArrayOfTicketNote
     * @uses ArrayOfTicketNote::setTicketNote()
     * @param \SGCIS\Struct\TicketNote[] $ticketNote
     */
    public function __construct(array $ticketNote = array())
    {
        $this
            ->setTicketNote($ticketNote);
    }
    /**
     * Get TicketNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\TicketNote[]|null
     */
    public function getTicketNote()
    {
        return isset($this->TicketNote) ? $this->TicketNote : null;
    }
    /**
     * Set TicketNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\TicketNote[] $ticketNote
     * @return \SGCIS\Array\ArrayOfTicketNote
     */
    public function setTicketNote(array $ticketNote = array())
    {
        foreach ($ticketNote as $arrayOfTicketNoteTicketNoteItem) {
            // validation for constraint: itemType
            if (!$arrayOfTicketNoteTicketNoteItem instanceof \SGCIS\Struct\TicketNote) {
                throw new \InvalidArgumentException(sprintf('The TicketNote property can only contain items of \SGCIS\Struct\TicketNote, "%s" given', is_object($arrayOfTicketNoteTicketNoteItem) ? get_class($arrayOfTicketNoteTicketNoteItem) : gettype($arrayOfTicketNoteTicketNoteItem)), __LINE__);
            }
        }
        if (is_null($ticketNote) || (is_array($ticketNote) && empty($ticketNote))) {
            unset($this->TicketNote);
        } else {
            $this->TicketNote = $ticketNote;
        }
        return $this;
    }
    /**
     * Add item to TicketNote value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\TicketNote $item
     * @return \SGCIS\Array\ArrayOfTicketNote
     */
    public function addToTicketNote(\SGCIS\Struct\TicketNote $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\TicketNote) {
            throw new \InvalidArgumentException(sprintf('The TicketNote property can only contain items of \SGCIS\Struct\TicketNote, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketNote[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\TicketNote|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\TicketNote|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\TicketNote|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\TicketNote|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\TicketNote|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TicketNote
     */
    public function getAttributeName()
    {
        return 'TicketNote';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfTicketNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
