<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSystemProperty Array
 * @subpackage Arrays
 */
class ArrayOfSystemProperty extends AbstractStructArrayBase
{
    /**
     * The SystemProperty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\SystemProperty[]
     */
    public $SystemProperty;
    /**
     * Constructor method for ArrayOfSystemProperty
     * @uses ArrayOfSystemProperty::setSystemProperty()
     * @param \SGCIS\Struct\SystemProperty[] $systemProperty
     */
    public function __construct(array $systemProperty = array())
    {
        $this
            ->setSystemProperty($systemProperty);
    }
    /**
     * Get SystemProperty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\SystemProperty[]|null
     */
    public function getSystemProperty()
    {
        return isset($this->SystemProperty) ? $this->SystemProperty : null;
    }
    /**
     * Set SystemProperty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemProperty[] $systemProperty
     * @return \SGCIS\Array\ArrayOfSystemProperty
     */
    public function setSystemProperty(array $systemProperty = array())
    {
        foreach ($systemProperty as $arrayOfSystemPropertySystemPropertyItem) {
            // validation for constraint: itemType
            if (!$arrayOfSystemPropertySystemPropertyItem instanceof \SGCIS\Struct\SystemProperty) {
                throw new \InvalidArgumentException(sprintf('The SystemProperty property can only contain items of \SGCIS\Struct\SystemProperty, "%s" given', is_object($arrayOfSystemPropertySystemPropertyItem) ? get_class($arrayOfSystemPropertySystemPropertyItem) : gettype($arrayOfSystemPropertySystemPropertyItem)), __LINE__);
            }
        }
        if (is_null($systemProperty) || (is_array($systemProperty) && empty($systemProperty))) {
            unset($this->SystemProperty);
        } else {
            $this->SystemProperty = $systemProperty;
        }
        return $this;
    }
    /**
     * Add item to SystemProperty value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemProperty $item
     * @return \SGCIS\Array\ArrayOfSystemProperty
     */
    public function addToSystemProperty(\SGCIS\Struct\SystemProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\SystemProperty) {
            throw new \InvalidArgumentException(sprintf('The SystemProperty property can only contain items of \SGCIS\Struct\SystemProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SystemProperty[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\SystemProperty|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\SystemProperty|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\SystemProperty|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\SystemProperty|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\SystemProperty|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SystemProperty
     */
    public function getAttributeName()
    {
        return 'SystemProperty';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfSystemProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
