<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSystemApplicationRoleProduct Array
 * @subpackage Arrays
 */
class ArrayOfSystemApplicationRoleProduct extends AbstractStructArrayBase
{
    /**
     * The SystemApplicationRoleProduct
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\SystemApplicationRoleProduct[]
     */
    public $SystemApplicationRoleProduct;
    /**
     * Constructor method for ArrayOfSystemApplicationRoleProduct
     * @uses ArrayOfSystemApplicationRoleProduct::setSystemApplicationRoleProduct()
     * @param \SGCIS\Struct\SystemApplicationRoleProduct[] $systemApplicationRoleProduct
     */
    public function __construct(array $systemApplicationRoleProduct = array())
    {
        $this
            ->setSystemApplicationRoleProduct($systemApplicationRoleProduct);
    }
    /**
     * Get SystemApplicationRoleProduct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\SystemApplicationRoleProduct[]|null
     */
    public function getSystemApplicationRoleProduct()
    {
        return isset($this->SystemApplicationRoleProduct) ? $this->SystemApplicationRoleProduct : null;
    }
    /**
     * Set SystemApplicationRoleProduct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemApplicationRoleProduct[] $systemApplicationRoleProduct
     * @return \SGCIS\Array\ArrayOfSystemApplicationRoleProduct
     */
    public function setSystemApplicationRoleProduct(array $systemApplicationRoleProduct = array())
    {
        foreach ($systemApplicationRoleProduct as $arrayOfSystemApplicationRoleProductSystemApplicationRoleProductItem) {
            // validation for constraint: itemType
            if (!$arrayOfSystemApplicationRoleProductSystemApplicationRoleProductItem instanceof \SGCIS\Struct\SystemApplicationRoleProduct) {
                throw new \InvalidArgumentException(sprintf('The SystemApplicationRoleProduct property can only contain items of \SGCIS\Struct\SystemApplicationRoleProduct, "%s" given', is_object($arrayOfSystemApplicationRoleProductSystemApplicationRoleProductItem) ? get_class($arrayOfSystemApplicationRoleProductSystemApplicationRoleProductItem) : gettype($arrayOfSystemApplicationRoleProductSystemApplicationRoleProductItem)), __LINE__);
            }
        }
        if (is_null($systemApplicationRoleProduct) || (is_array($systemApplicationRoleProduct) && empty($systemApplicationRoleProduct))) {
            unset($this->SystemApplicationRoleProduct);
        } else {
            $this->SystemApplicationRoleProduct = $systemApplicationRoleProduct;
        }
        return $this;
    }
    /**
     * Add item to SystemApplicationRoleProduct value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemApplicationRoleProduct $item
     * @return \SGCIS\Array\ArrayOfSystemApplicationRoleProduct
     */
    public function addToSystemApplicationRoleProduct(\SGCIS\Struct\SystemApplicationRoleProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\SystemApplicationRoleProduct) {
            throw new \InvalidArgumentException(sprintf('The SystemApplicationRoleProduct property can only contain items of \SGCIS\Struct\SystemApplicationRoleProduct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SystemApplicationRoleProduct[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\SystemApplicationRoleProduct|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\SystemApplicationRoleProduct|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\SystemApplicationRoleProduct|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\SystemApplicationRoleProduct|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\SystemApplicationRoleProduct|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SystemApplicationRoleProduct
     */
    public function getAttributeName()
    {
        return 'SystemApplicationRoleProduct';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfSystemApplicationRoleProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
