<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServicePointMeter Array
 * @subpackage Arrays
 */
class ArrayOfServicePointMeter extends AbstractStructArrayBase
{
    /**
     * The ServicePointMeter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ServicePointMeter[]
     */
    public $ServicePointMeter;
    /**
     * Constructor method for ArrayOfServicePointMeter
     * @uses ArrayOfServicePointMeter::setServicePointMeter()
     * @param \SGCIS\Struct\ServicePointMeter[] $servicePointMeter
     */
    public function __construct(array $servicePointMeter = array())
    {
        $this
            ->setServicePointMeter($servicePointMeter);
    }
    /**
     * Get ServicePointMeter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ServicePointMeter[]|null
     */
    public function getServicePointMeter()
    {
        return isset($this->ServicePointMeter) ? $this->ServicePointMeter : null;
    }
    /**
     * Set ServicePointMeter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ServicePointMeter[] $servicePointMeter
     * @return \SGCIS\Array\ArrayOfServicePointMeter
     */
    public function setServicePointMeter(array $servicePointMeter = array())
    {
        foreach ($servicePointMeter as $arrayOfServicePointMeterServicePointMeterItem) {
            // validation for constraint: itemType
            if (!$arrayOfServicePointMeterServicePointMeterItem instanceof \SGCIS\Struct\ServicePointMeter) {
                throw new \InvalidArgumentException(sprintf('The ServicePointMeter property can only contain items of \SGCIS\Struct\ServicePointMeter, "%s" given', is_object($arrayOfServicePointMeterServicePointMeterItem) ? get_class($arrayOfServicePointMeterServicePointMeterItem) : gettype($arrayOfServicePointMeterServicePointMeterItem)), __LINE__);
            }
        }
        if (is_null($servicePointMeter) || (is_array($servicePointMeter) && empty($servicePointMeter))) {
            unset($this->ServicePointMeter);
        } else {
            $this->ServicePointMeter = $servicePointMeter;
        }
        return $this;
    }
    /**
     * Add item to ServicePointMeter value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ServicePointMeter $item
     * @return \SGCIS\Array\ArrayOfServicePointMeter
     */
    public function addToServicePointMeter(\SGCIS\Struct\ServicePointMeter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ServicePointMeter) {
            throw new \InvalidArgumentException(sprintf('The ServicePointMeter property can only contain items of \SGCIS\Struct\ServicePointMeter, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServicePointMeter[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ServicePointMeter|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ServicePointMeter|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ServicePointMeter|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ServicePointMeter|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ServicePointMeter|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServicePointMeter
     */
    public function getAttributeName()
    {
        return 'ServicePointMeter';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfServicePointMeter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
