<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServiceOrder Array
 * @subpackage Arrays
 */
class ArrayOfServiceOrder extends AbstractStructArrayBase
{
    /**
     * The ServiceOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ServiceOrder[]
     */
    public $ServiceOrder;
    /**
     * Constructor method for ArrayOfServiceOrder
     * @uses ArrayOfServiceOrder::setServiceOrder()
     * @param \SGCIS\Struct\ServiceOrder[] $serviceOrder
     */
    public function __construct(array $serviceOrder = array())
    {
        $this
            ->setServiceOrder($serviceOrder);
    }
    /**
     * Get ServiceOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ServiceOrder[]|null
     */
    public function getServiceOrder()
    {
        return isset($this->ServiceOrder) ? $this->ServiceOrder : null;
    }
    /**
     * Set ServiceOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ServiceOrder[] $serviceOrder
     * @return \SGCIS\Array\ArrayOfServiceOrder
     */
    public function setServiceOrder(array $serviceOrder = array())
    {
        foreach ($serviceOrder as $arrayOfServiceOrderServiceOrderItem) {
            // validation for constraint: itemType
            if (!$arrayOfServiceOrderServiceOrderItem instanceof \SGCIS\Struct\ServiceOrder) {
                throw new \InvalidArgumentException(sprintf('The ServiceOrder property can only contain items of \SGCIS\Struct\ServiceOrder, "%s" given', is_object($arrayOfServiceOrderServiceOrderItem) ? get_class($arrayOfServiceOrderServiceOrderItem) : gettype($arrayOfServiceOrderServiceOrderItem)), __LINE__);
            }
        }
        if (is_null($serviceOrder) || (is_array($serviceOrder) && empty($serviceOrder))) {
            unset($this->ServiceOrder);
        } else {
            $this->ServiceOrder = $serviceOrder;
        }
        return $this;
    }
    /**
     * Add item to ServiceOrder value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ServiceOrder $item
     * @return \SGCIS\Array\ArrayOfServiceOrder
     */
    public function addToServiceOrder(\SGCIS\Struct\ServiceOrder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ServiceOrder) {
            throw new \InvalidArgumentException(sprintf('The ServiceOrder property can only contain items of \SGCIS\Struct\ServiceOrder, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceOrder[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ServiceOrder|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ServiceOrder|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ServiceOrder|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ServiceOrder|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ServiceOrder|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceOrder
     */
    public function getAttributeName()
    {
        return 'ServiceOrder';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfServiceOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
