<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRate Array
 * @subpackage Arrays
 */
class ArrayOfRate extends AbstractStructArrayBase
{
    /**
     * The Rate
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\Rate[]
     */
    public $Rate;
    /**
     * Constructor method for ArrayOfRate
     * @uses ArrayOfRate::setRate()
     * @param \SGCIS\Struct\Rate[] $rate
     */
    public function __construct(array $rate = array())
    {
        $this
            ->setRate($rate);
    }
    /**
     * Get Rate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\Rate[]|null
     */
    public function getRate()
    {
        return isset($this->Rate) ? $this->Rate : null;
    }
    /**
     * Set Rate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\Rate[] $rate
     * @return \SGCIS\Array\ArrayOfRate
     */
    public function setRate(array $rate = array())
    {
        foreach ($rate as $arrayOfRateRateItem) {
            // validation for constraint: itemType
            if (!$arrayOfRateRateItem instanceof \SGCIS\Struct\Rate) {
                throw new \InvalidArgumentException(sprintf('The Rate property can only contain items of \SGCIS\Struct\Rate, "%s" given', is_object($arrayOfRateRateItem) ? get_class($arrayOfRateRateItem) : gettype($arrayOfRateRateItem)), __LINE__);
            }
        }
        if (is_null($rate) || (is_array($rate) && empty($rate))) {
            unset($this->Rate);
        } else {
            $this->Rate = $rate;
        }
        return $this;
    }
    /**
     * Add item to Rate value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\Rate $item
     * @return \SGCIS\Array\ArrayOfRate
     */
    public function addToRate(\SGCIS\Struct\Rate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\Rate) {
            throw new \InvalidArgumentException(sprintf('The Rate property can only contain items of \SGCIS\Struct\Rate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Rate[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\Rate|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\Rate|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\Rate|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\Rate|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\Rate|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Rate
     */
    public function getAttributeName()
    {
        return 'Rate';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
