<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProduct Array
 * @subpackage Arrays
 */
class ArrayOfProduct extends AbstractStructArrayBase
{
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\Product[]
     */
    public $Product;
    /**
     * Constructor method for ArrayOfProduct
     * @uses ArrayOfProduct::setProduct()
     * @param \SGCIS\Struct\Product[] $product
     */
    public function __construct(array $product = array())
    {
        $this
            ->setProduct($product);
    }
    /**
     * Get Product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\Product[]|null
     */
    public function getProduct()
    {
        return isset($this->Product) ? $this->Product : null;
    }
    /**
     * Set Product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\Product[] $product
     * @return \SGCIS\Array\ArrayOfProduct
     */
    public function setProduct(array $product = array())
    {
        foreach ($product as $arrayOfProductProductItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductProductItem instanceof \SGCIS\Struct\Product) {
                throw new \InvalidArgumentException(sprintf('The Product property can only contain items of \SGCIS\Struct\Product, "%s" given', is_object($arrayOfProductProductItem) ? get_class($arrayOfProductProductItem) : gettype($arrayOfProductProductItem)), __LINE__);
            }
        }
        if (is_null($product) || (is_array($product) && empty($product))) {
            unset($this->Product);
        } else {
            $this->Product = $product;
        }
        return $this;
    }
    /**
     * Add item to Product value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\Product $item
     * @return \SGCIS\Array\ArrayOfProduct
     */
    public function addToProduct(\SGCIS\Struct\Product $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\Product) {
            throw new \InvalidArgumentException(sprintf('The Product property can only contain items of \SGCIS\Struct\Product, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Product[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\Product|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\Product|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\Product|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\Product|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\Product|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Product
     */
    public function getAttributeName()
    {
        return 'Product';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
