<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentArrangementBill Array
 * @subpackage Arrays
 */
class ArrayOfPaymentArrangementBill extends AbstractStructArrayBase
{
    /**
     * The PaymentArrangementBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\PaymentArrangementBill[]
     */
    public $PaymentArrangementBill;
    /**
     * Constructor method for ArrayOfPaymentArrangementBill
     * @uses ArrayOfPaymentArrangementBill::setPaymentArrangementBill()
     * @param \SGCIS\Struct\PaymentArrangementBill[] $paymentArrangementBill
     */
    public function __construct(array $paymentArrangementBill = array())
    {
        $this
            ->setPaymentArrangementBill($paymentArrangementBill);
    }
    /**
     * Get PaymentArrangementBill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\PaymentArrangementBill[]|null
     */
    public function getPaymentArrangementBill()
    {
        return isset($this->PaymentArrangementBill) ? $this->PaymentArrangementBill : null;
    }
    /**
     * Set PaymentArrangementBill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\PaymentArrangementBill[] $paymentArrangementBill
     * @return \SGCIS\Array\ArrayOfPaymentArrangementBill
     */
    public function setPaymentArrangementBill(array $paymentArrangementBill = array())
    {
        foreach ($paymentArrangementBill as $arrayOfPaymentArrangementBillPaymentArrangementBillItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentArrangementBillPaymentArrangementBillItem instanceof \SGCIS\Struct\PaymentArrangementBill) {
                throw new \InvalidArgumentException(sprintf('The PaymentArrangementBill property can only contain items of \SGCIS\Struct\PaymentArrangementBill, "%s" given', is_object($arrayOfPaymentArrangementBillPaymentArrangementBillItem) ? get_class($arrayOfPaymentArrangementBillPaymentArrangementBillItem) : gettype($arrayOfPaymentArrangementBillPaymentArrangementBillItem)), __LINE__);
            }
        }
        if (is_null($paymentArrangementBill) || (is_array($paymentArrangementBill) && empty($paymentArrangementBill))) {
            unset($this->PaymentArrangementBill);
        } else {
            $this->PaymentArrangementBill = $paymentArrangementBill;
        }
        return $this;
    }
    /**
     * Add item to PaymentArrangementBill value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\PaymentArrangementBill $item
     * @return \SGCIS\Array\ArrayOfPaymentArrangementBill
     */
    public function addToPaymentArrangementBill(\SGCIS\Struct\PaymentArrangementBill $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\PaymentArrangementBill) {
            throw new \InvalidArgumentException(sprintf('The PaymentArrangementBill property can only contain items of \SGCIS\Struct\PaymentArrangementBill, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentArrangementBill[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\PaymentArrangementBill|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\PaymentArrangementBill|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\PaymentArrangementBill|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\PaymentArrangementBill|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\PaymentArrangementBill|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentArrangementBill
     */
    public function getAttributeName()
    {
        return 'PaymentArrangementBill';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfPaymentArrangementBill
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
