<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNameValuePair Array
 * @subpackage Arrays
 */
class ArrayOfNameValuePair extends AbstractStructArrayBase
{
    /**
     * The NameValuePair
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\NameValuePair[]
     */
    public $NameValuePair;
    /**
     * Constructor method for ArrayOfNameValuePair
     * @uses ArrayOfNameValuePair::setNameValuePair()
     * @param \SGCIS\Struct\NameValuePair[] $nameValuePair
     */
    public function __construct(array $nameValuePair = array())
    {
        $this
            ->setNameValuePair($nameValuePair);
    }
    /**
     * Get NameValuePair value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\NameValuePair[]|null
     */
    public function getNameValuePair()
    {
        return isset($this->NameValuePair) ? $this->NameValuePair : null;
    }
    /**
     * Set NameValuePair value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\NameValuePair[] $nameValuePair
     * @return \SGCIS\Array\ArrayOfNameValuePair
     */
    public function setNameValuePair(array $nameValuePair = array())
    {
        foreach ($nameValuePair as $arrayOfNameValuePairNameValuePairItem) {
            // validation for constraint: itemType
            if (!$arrayOfNameValuePairNameValuePairItem instanceof \SGCIS\Struct\NameValuePair) {
                throw new \InvalidArgumentException(sprintf('The NameValuePair property can only contain items of \SGCIS\Struct\NameValuePair, "%s" given', is_object($arrayOfNameValuePairNameValuePairItem) ? get_class($arrayOfNameValuePairNameValuePairItem) : gettype($arrayOfNameValuePairNameValuePairItem)), __LINE__);
            }
        }
        if (is_null($nameValuePair) || (is_array($nameValuePair) && empty($nameValuePair))) {
            unset($this->NameValuePair);
        } else {
            $this->NameValuePair = $nameValuePair;
        }
        return $this;
    }
    /**
     * Add item to NameValuePair value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\NameValuePair $item
     * @return \SGCIS\Array\ArrayOfNameValuePair
     */
    public function addToNameValuePair(\SGCIS\Struct\NameValuePair $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\NameValuePair) {
            throw new \InvalidArgumentException(sprintf('The NameValuePair property can only contain items of \SGCIS\Struct\NameValuePair, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NameValuePair[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\NameValuePair|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\NameValuePair|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\NameValuePair|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\NameValuePair|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\NameValuePair|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NameValuePair
     */
    public function getAttributeName()
    {
        return 'NameValuePair';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfNameValuePair
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
