<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMeterGroup Array
 * @subpackage Arrays
 */
class ArrayOfMeterGroup extends AbstractStructArrayBase
{
    /**
     * The MeterGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\MeterGroup[]
     */
    public $MeterGroup;
    /**
     * Constructor method for ArrayOfMeterGroup
     * @uses ArrayOfMeterGroup::setMeterGroup()
     * @param \SGCIS\Struct\MeterGroup[] $meterGroup
     */
    public function __construct(array $meterGroup = array())
    {
        $this
            ->setMeterGroup($meterGroup);
    }
    /**
     * Get MeterGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\MeterGroup[]|null
     */
    public function getMeterGroup()
    {
        return isset($this->MeterGroup) ? $this->MeterGroup : null;
    }
    /**
     * Set MeterGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\MeterGroup[] $meterGroup
     * @return \SGCIS\Array\ArrayOfMeterGroup
     */
    public function setMeterGroup(array $meterGroup = array())
    {
        foreach ($meterGroup as $arrayOfMeterGroupMeterGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfMeterGroupMeterGroupItem instanceof \SGCIS\Struct\MeterGroup) {
                throw new \InvalidArgumentException(sprintf('The MeterGroup property can only contain items of \SGCIS\Struct\MeterGroup, "%s" given', is_object($arrayOfMeterGroupMeterGroupItem) ? get_class($arrayOfMeterGroupMeterGroupItem) : gettype($arrayOfMeterGroupMeterGroupItem)), __LINE__);
            }
        }
        if (is_null($meterGroup) || (is_array($meterGroup) && empty($meterGroup))) {
            unset($this->MeterGroup);
        } else {
            $this->MeterGroup = $meterGroup;
        }
        return $this;
    }
    /**
     * Add item to MeterGroup value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\MeterGroup $item
     * @return \SGCIS\Array\ArrayOfMeterGroup
     */
    public function addToMeterGroup(\SGCIS\Struct\MeterGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\MeterGroup) {
            throw new \InvalidArgumentException(sprintf('The MeterGroup property can only contain items of \SGCIS\Struct\MeterGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MeterGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\MeterGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\MeterGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\MeterGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\MeterGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\MeterGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MeterGroup
     */
    public function getAttributeName()
    {
        return 'MeterGroup';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfMeterGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
