<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfChargeGroup Array
 * @subpackage Arrays
 */
class ArrayOfChargeGroup extends AbstractStructArrayBase
{
    /**
     * The ChargeGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ChargeGroup[]
     */
    public $ChargeGroup;
    /**
     * Constructor method for ArrayOfChargeGroup
     * @uses ArrayOfChargeGroup::setChargeGroup()
     * @param \SGCIS\Struct\ChargeGroup[] $chargeGroup
     */
    public function __construct(array $chargeGroup = array())
    {
        $this
            ->setChargeGroup($chargeGroup);
    }
    /**
     * Get ChargeGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ChargeGroup[]|null
     */
    public function getChargeGroup()
    {
        return isset($this->ChargeGroup) ? $this->ChargeGroup : null;
    }
    /**
     * Set ChargeGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ChargeGroup[] $chargeGroup
     * @return \SGCIS\Array\ArrayOfChargeGroup
     */
    public function setChargeGroup(array $chargeGroup = array())
    {
        foreach ($chargeGroup as $arrayOfChargeGroupChargeGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfChargeGroupChargeGroupItem instanceof \SGCIS\Struct\ChargeGroup) {
                throw new \InvalidArgumentException(sprintf('The ChargeGroup property can only contain items of \SGCIS\Struct\ChargeGroup, "%s" given', is_object($arrayOfChargeGroupChargeGroupItem) ? get_class($arrayOfChargeGroupChargeGroupItem) : gettype($arrayOfChargeGroupChargeGroupItem)), __LINE__);
            }
        }
        if (is_null($chargeGroup) || (is_array($chargeGroup) && empty($chargeGroup))) {
            unset($this->ChargeGroup);
        } else {
            $this->ChargeGroup = $chargeGroup;
        }
        return $this;
    }
    /**
     * Add item to ChargeGroup value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ChargeGroup $item
     * @return \SGCIS\Array\ArrayOfChargeGroup
     */
    public function addToChargeGroup(\SGCIS\Struct\ChargeGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ChargeGroup) {
            throw new \InvalidArgumentException(sprintf('The ChargeGroup property can only contain items of \SGCIS\Struct\ChargeGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ChargeGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ChargeGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ChargeGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ChargeGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ChargeGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ChargeGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ChargeGroup
     */
    public function getAttributeName()
    {
        return 'ChargeGroup';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfChargeGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
