<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBillStatusCount Array
 * @subpackage Arrays
 */
class ArrayOfBillStatusCount extends AbstractStructArrayBase
{
    /**
     * The BillStatusCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\BillStatusCount[]
     */
    public $BillStatusCount;
    /**
     * Constructor method for ArrayOfBillStatusCount
     * @uses ArrayOfBillStatusCount::setBillStatusCount()
     * @param \SGCIS\Struct\BillStatusCount[] $billStatusCount
     */
    public function __construct(array $billStatusCount = array())
    {
        $this
            ->setBillStatusCount($billStatusCount);
    }
    /**
     * Get BillStatusCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\BillStatusCount[]|null
     */
    public function getBillStatusCount()
    {
        return isset($this->BillStatusCount) ? $this->BillStatusCount : null;
    }
    /**
     * Set BillStatusCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillStatusCount[] $billStatusCount
     * @return \SGCIS\Array\ArrayOfBillStatusCount
     */
    public function setBillStatusCount(array $billStatusCount = array())
    {
        foreach ($billStatusCount as $arrayOfBillStatusCountBillStatusCountItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillStatusCountBillStatusCountItem instanceof \SGCIS\Struct\BillStatusCount) {
                throw new \InvalidArgumentException(sprintf('The BillStatusCount property can only contain items of \SGCIS\Struct\BillStatusCount, "%s" given', is_object($arrayOfBillStatusCountBillStatusCountItem) ? get_class($arrayOfBillStatusCountBillStatusCountItem) : gettype($arrayOfBillStatusCountBillStatusCountItem)), __LINE__);
            }
        }
        if (is_null($billStatusCount) || (is_array($billStatusCount) && empty($billStatusCount))) {
            unset($this->BillStatusCount);
        } else {
            $this->BillStatusCount = $billStatusCount;
        }
        return $this;
    }
    /**
     * Add item to BillStatusCount value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillStatusCount $item
     * @return \SGCIS\Array\ArrayOfBillStatusCount
     */
    public function addToBillStatusCount(\SGCIS\Struct\BillStatusCount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\BillStatusCount) {
            throw new \InvalidArgumentException(sprintf('The BillStatusCount property can only contain items of \SGCIS\Struct\BillStatusCount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillStatusCount[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\BillStatusCount|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\BillStatusCount|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\BillStatusCount|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\BillStatusCount|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\BillStatusCount|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BillStatusCount
     */
    public function getAttributeName()
    {
        return 'BillStatusCount';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfBillStatusCount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
