<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountDepositSchedule Array
 * @subpackage Arrays
 */
class ArrayOfAccountDepositSchedule extends AbstractStructArrayBase
{
    /**
     * The AccountDepositSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountDepositSchedule[]
     */
    public $AccountDepositSchedule;
    /**
     * Constructor method for ArrayOfAccountDepositSchedule
     * @uses ArrayOfAccountDepositSchedule::setAccountDepositSchedule()
     * @param \SGCIS\Struct\AccountDepositSchedule[] $accountDepositSchedule
     */
    public function __construct(array $accountDepositSchedule = array())
    {
        $this
            ->setAccountDepositSchedule($accountDepositSchedule);
    }
    /**
     * Get AccountDepositSchedule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountDepositSchedule[]|null
     */
    public function getAccountDepositSchedule()
    {
        return isset($this->AccountDepositSchedule) ? $this->AccountDepositSchedule : null;
    }
    /**
     * Set AccountDepositSchedule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountDepositSchedule[] $accountDepositSchedule
     * @return \SGCIS\Array\ArrayOfAccountDepositSchedule
     */
    public function setAccountDepositSchedule(array $accountDepositSchedule = array())
    {
        foreach ($accountDepositSchedule as $arrayOfAccountDepositScheduleAccountDepositScheduleItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountDepositScheduleAccountDepositScheduleItem instanceof \SGCIS\Struct\AccountDepositSchedule) {
                throw new \InvalidArgumentException(sprintf('The AccountDepositSchedule property can only contain items of \SGCIS\Struct\AccountDepositSchedule, "%s" given', is_object($arrayOfAccountDepositScheduleAccountDepositScheduleItem) ? get_class($arrayOfAccountDepositScheduleAccountDepositScheduleItem) : gettype($arrayOfAccountDepositScheduleAccountDepositScheduleItem)), __LINE__);
            }
        }
        if (is_null($accountDepositSchedule) || (is_array($accountDepositSchedule) && empty($accountDepositSchedule))) {
            unset($this->AccountDepositSchedule);
        } else {
            $this->AccountDepositSchedule = $accountDepositSchedule;
        }
        return $this;
    }
    /**
     * Add item to AccountDepositSchedule value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountDepositSchedule $item
     * @return \SGCIS\Array\ArrayOfAccountDepositSchedule
     */
    public function addToAccountDepositSchedule(\SGCIS\Struct\AccountDepositSchedule $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountDepositSchedule) {
            throw new \InvalidArgumentException(sprintf('The AccountDepositSchedule property can only contain items of \SGCIS\Struct\AccountDepositSchedule, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountDepositSchedule[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountDepositSchedule|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountDepositSchedule|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountDepositSchedule|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountDepositSchedule|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountDepositSchedule|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountDepositSchedule
     */
    public function getAttributeName()
    {
        return 'AccountDepositSchedule';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountDepositSchedule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
