<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Errore StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Errore
 * @subpackage Structs
 */
class Errore extends AbstractStructBase
{
    /**
     * The Codice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Codice;
    /**
     * The Descrizione
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descrizione;
    /**
     * Constructor method for Errore
     * @uses Errore::setCodice()
     * @uses Errore::setDescrizione()
     * @param string $codice
     * @param string $descrizione
     */
    public function __construct($codice = null, $descrizione = null)
    {
        $this
            ->setCodice($codice)
            ->setDescrizione($descrizione);
    }
    /**
     * Get Codice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodice()
    {
        return isset($this->Codice) ? $this->Codice : null;
    }
    /**
     * Set Codice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codice
     * @return \StructType\Errore
     */
    public function setCodice($codice = null)
    {
        // validation for constraint: string
        if (!is_null($codice) && !is_string($codice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codice)), __LINE__);
        }
        if (is_null($codice) || (is_array($codice) && empty($codice))) {
            unset($this->Codice);
        } else {
            $this->Codice = $codice;
        }
        return $this;
    }
    /**
     * Get Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizione()
    {
        return isset($this->Descrizione) ? $this->Descrizione : null;
    }
    /**
     * Set Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizione
     * @return \StructType\Errore
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descrizione)), __LINE__);
        }
        if (is_null($descrizione) || (is_array($descrizione) && empty($descrizione))) {
            unset($this->Descrizione);
        } else {
            $this->Descrizione = $descrizione;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Errore
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
