<?php

namespace EnumType;

/**
 * This class stands for StatoDelega EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StatoDelega
 * @subpackage Enumerations
 */
class StatoDelega
{
    /**
     * Constant for value 'Pagata'
     * @return string 'Pagata'
     */
    const VALUE_PAGATA = 'Pagata';
    /**
     * Constant for value 'NonPagata'
     * @return string 'NonPagata'
     */
    const VALUE_NON_PAGATA = 'NonPagata';
    /**
     * Constant for value 'PagamentoPrenotato'
     * @return string 'PagamentoPrenotato'
     */
    const VALUE_PAGAMENTO_PRENOTATO = 'PagamentoPrenotato';
    /**
     * Constant for value 'PagamentoStornato'
     * @return string 'PagamentoStornato'
     */
    const VALUE_PAGAMENTO_STORNATO = 'PagamentoStornato';
    /**
     * Constant for value 'PagamentoRendicontato'
     * @return string 'PagamentoRendicontato'
     */
    const VALUE_PAGAMENTO_RENDICONTATO = 'PagamentoRendicontato';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PAGATA
     * @uses self::VALUE_NON_PAGATA
     * @uses self::VALUE_PAGAMENTO_PRENOTATO
     * @uses self::VALUE_PAGAMENTO_STORNATO
     * @uses self::VALUE_PAGAMENTO_RENDICONTATO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PAGATA,
            self::VALUE_NON_PAGATA,
            self::VALUE_PAGAMENTO_PRENOTATO,
            self::VALUE_PAGAMENTO_STORNATO,
            self::VALUE_PAGAMENTO_RENDICONTATO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
