<?php

namespace EnumType;

/**
 * This class stands for Sezione EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Sezione
 * @subpackage Enumerations
 */
class Sezione
{
    /**
     * Constant for value 'ER'
     * @return string 'ER'
     */
    const VALUE_ER = 'ER';
    /**
     * Constant for value 'RG'
     * @return string 'RG'
     */
    const VALUE_RG = 'RG';
    /**
     * Constant for value 'EL'
     * @return string 'EL'
     */
    const VALUE_EL = 'EL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ER
     * @uses self::VALUE_RG
     * @uses self::VALUE_EL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ER,
            self::VALUE_RG,
            self::VALUE_EL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
