<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DelegaF24 StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DelegaF24
 * @subpackage Structs
 */
class DelegaF24 extends AbstractStructBase
{
    /**
     * The CodiceAtto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceAtto;
    /**
     * The CodiceUfficio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceUfficio;
    /**
     * The Contribuente
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contribuente
     */
    public $Contribuente;
    /**
     * The DataScadenza
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataScadenza;
    /**
     * The Descrizione
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descrizione;
    /**
     * The Fornitore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fornitore;
    /**
     * The IdentificativoDelegaDicontratto
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IdentificativoDelegaDicontratto;
    /**
     * The IdentificativoOperazione
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentificativoOperazione;
    /**
     * The ImportoInCentesimi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ImportoInCentesimi;
    /**
     * The RigheDelegaF24
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRigaDelegaF24
     */
    public $RigheDelegaF24;
    /**
     * The CodiceIdentificativo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceIdentificativo;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The StatoDelega
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatoDelega;
    /**
     * The Valida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Valida;
    /**
     * Constructor method for DelegaF24
     * @uses DelegaF24::setCodiceAtto()
     * @uses DelegaF24::setCodiceUfficio()
     * @uses DelegaF24::setContribuente()
     * @uses DelegaF24::setDataScadenza()
     * @uses DelegaF24::setDescrizione()
     * @uses DelegaF24::setFornitore()
     * @uses DelegaF24::setIdentificativoDelegaDicontratto()
     * @uses DelegaF24::setIdentificativoOperazione()
     * @uses DelegaF24::setImportoInCentesimi()
     * @uses DelegaF24::setRigheDelegaF24()
     * @uses DelegaF24::setCodiceIdentificativo()
     * @uses DelegaF24::setId()
     * @uses DelegaF24::setStatoDelega()
     * @uses DelegaF24::setValida()
     * @param string $codiceAtto
     * @param string $codiceUfficio
     * @param \StructType\Contribuente $contribuente
     * @param string $dataScadenza
     * @param string $descrizione
     * @param string $fornitore
     * @param string $identificativoDelegaDicontratto
     * @param string $identificativoOperazione
     * @param int $importoInCentesimi
     * @param \ArrayType\ArrayOfRigaDelegaF24 $righeDelegaF24
     * @param string $codiceIdentificativo
     * @param string $id
     * @param string $statoDelega
     * @param bool $valida
     */
    public function __construct($codiceAtto = null, $codiceUfficio = null, \StructType\Contribuente $contribuente = null, $dataScadenza = null, $descrizione = null, $fornitore = null, $identificativoDelegaDicontratto = null, $identificativoOperazione = null, $importoInCentesimi = null, \ArrayType\ArrayOfRigaDelegaF24 $righeDelegaF24 = null, $codiceIdentificativo = null, $id = null, $statoDelega = null, $valida = null)
    {
        $this
            ->setCodiceAtto($codiceAtto)
            ->setCodiceUfficio($codiceUfficio)
            ->setContribuente($contribuente)
            ->setDataScadenza($dataScadenza)
            ->setDescrizione($descrizione)
            ->setFornitore($fornitore)
            ->setIdentificativoDelegaDicontratto($identificativoDelegaDicontratto)
            ->setIdentificativoOperazione($identificativoOperazione)
            ->setImportoInCentesimi($importoInCentesimi)
            ->setRigheDelegaF24($righeDelegaF24)
            ->setCodiceIdentificativo($codiceIdentificativo)
            ->setId($id)
            ->setStatoDelega($statoDelega)
            ->setValida($valida);
    }
    /**
     * Get CodiceAtto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceAtto()
    {
        return isset($this->CodiceAtto) ? $this->CodiceAtto : null;
    }
    /**
     * Set CodiceAtto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceAtto
     * @return \StructType\DelegaF24
     */
    public function setCodiceAtto($codiceAtto = null)
    {
        // validation for constraint: string
        if (!is_null($codiceAtto) && !is_string($codiceAtto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codiceAtto)), __LINE__);
        }
        if (is_null($codiceAtto) || (is_array($codiceAtto) && empty($codiceAtto))) {
            unset($this->CodiceAtto);
        } else {
            $this->CodiceAtto = $codiceAtto;
        }
        return $this;
    }
    /**
     * Get CodiceUfficio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceUfficio()
    {
        return isset($this->CodiceUfficio) ? $this->CodiceUfficio : null;
    }
    /**
     * Set CodiceUfficio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceUfficio
     * @return \StructType\DelegaF24
     */
    public function setCodiceUfficio($codiceUfficio = null)
    {
        // validation for constraint: string
        if (!is_null($codiceUfficio) && !is_string($codiceUfficio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codiceUfficio)), __LINE__);
        }
        if (is_null($codiceUfficio) || (is_array($codiceUfficio) && empty($codiceUfficio))) {
            unset($this->CodiceUfficio);
        } else {
            $this->CodiceUfficio = $codiceUfficio;
        }
        return $this;
    }
    /**
     * Get Contribuente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contribuente|null
     */
    public function getContribuente()
    {
        return isset($this->Contribuente) ? $this->Contribuente : null;
    }
    /**
     * Set Contribuente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contribuente $contribuente
     * @return \StructType\DelegaF24
     */
    public function setContribuente(\StructType\Contribuente $contribuente = null)
    {
        if (is_null($contribuente) || (is_array($contribuente) && empty($contribuente))) {
            unset($this->Contribuente);
        } else {
            $this->Contribuente = $contribuente;
        }
        return $this;
    }
    /**
     * Get DataScadenza value
     * @return string|null
     */
    public function getDataScadenza()
    {
        return $this->DataScadenza;
    }
    /**
     * Set DataScadenza value
     * @param string $dataScadenza
     * @return \StructType\DelegaF24
     */
    public function setDataScadenza($dataScadenza = null)
    {
        // validation for constraint: string
        if (!is_null($dataScadenza) && !is_string($dataScadenza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataScadenza)), __LINE__);
        }
        $this->DataScadenza = $dataScadenza;
        return $this;
    }
    /**
     * Get Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizione()
    {
        return isset($this->Descrizione) ? $this->Descrizione : null;
    }
    /**
     * Set Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizione
     * @return \StructType\DelegaF24
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descrizione)), __LINE__);
        }
        if (is_null($descrizione) || (is_array($descrizione) && empty($descrizione))) {
            unset($this->Descrizione);
        } else {
            $this->Descrizione = $descrizione;
        }
        return $this;
    }
    /**
     * Get Fornitore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFornitore()
    {
        return isset($this->Fornitore) ? $this->Fornitore : null;
    }
    /**
     * Set Fornitore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fornitore
     * @return \StructType\DelegaF24
     */
    public function setFornitore($fornitore = null)
    {
        // validation for constraint: string
        if (!is_null($fornitore) && !is_string($fornitore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fornitore)), __LINE__);
        }
        if (is_null($fornitore) || (is_array($fornitore) && empty($fornitore))) {
            unset($this->Fornitore);
        } else {
            $this->Fornitore = $fornitore;
        }
        return $this;
    }
    /**
     * Get IdentificativoDelegaDicontratto value
     * @return string|null
     */
    public function getIdentificativoDelegaDicontratto()
    {
        return $this->IdentificativoDelegaDicontratto;
    }
    /**
     * Set IdentificativoDelegaDicontratto value
     * @param string $identificativoDelegaDicontratto
     * @return \StructType\DelegaF24
     */
    public function setIdentificativoDelegaDicontratto($identificativoDelegaDicontratto = null)
    {
        // validation for constraint: string
        if (!is_null($identificativoDelegaDicontratto) && !is_string($identificativoDelegaDicontratto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoDelegaDicontratto)), __LINE__);
        }
        $this->IdentificativoDelegaDicontratto = $identificativoDelegaDicontratto;
        return $this;
    }
    /**
     * Get IdentificativoOperazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentificativoOperazione()
    {
        return isset($this->IdentificativoOperazione) ? $this->IdentificativoOperazione : null;
    }
    /**
     * Set IdentificativoOperazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identificativoOperazione
     * @return \StructType\DelegaF24
     */
    public function setIdentificativoOperazione($identificativoOperazione = null)
    {
        // validation for constraint: string
        if (!is_null($identificativoOperazione) && !is_string($identificativoOperazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoOperazione)), __LINE__);
        }
        if (is_null($identificativoOperazione) || (is_array($identificativoOperazione) && empty($identificativoOperazione))) {
            unset($this->IdentificativoOperazione);
        } else {
            $this->IdentificativoOperazione = $identificativoOperazione;
        }
        return $this;
    }
    /**
     * Get ImportoInCentesimi value
     * @return int|null
     */
    public function getImportoInCentesimi()
    {
        return $this->ImportoInCentesimi;
    }
    /**
     * Set ImportoInCentesimi value
     * @param int $importoInCentesimi
     * @return \StructType\DelegaF24
     */
    public function setImportoInCentesimi($importoInCentesimi = null)
    {
        // validation for constraint: int
        if (!is_null($importoInCentesimi) && !is_numeric($importoInCentesimi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($importoInCentesimi)), __LINE__);
        }
        $this->ImportoInCentesimi = $importoInCentesimi;
        return $this;
    }
    /**
     * Get RigheDelegaF24 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRigaDelegaF24|null
     */
    public function getRigheDelegaF24()
    {
        return isset($this->RigheDelegaF24) ? $this->RigheDelegaF24 : null;
    }
    /**
     * Set RigheDelegaF24 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRigaDelegaF24 $righeDelegaF24
     * @return \StructType\DelegaF24
     */
    public function setRigheDelegaF24(\ArrayType\ArrayOfRigaDelegaF24 $righeDelegaF24 = null)
    {
        if (is_null($righeDelegaF24) || (is_array($righeDelegaF24) && empty($righeDelegaF24))) {
            unset($this->RigheDelegaF24);
        } else {
            $this->RigheDelegaF24 = $righeDelegaF24;
        }
        return $this;
    }
    /**
     * Get CodiceIdentificativo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceIdentificativo()
    {
        return isset($this->CodiceIdentificativo) ? $this->CodiceIdentificativo : null;
    }
    /**
     * Set CodiceIdentificativo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceIdentificativo
     * @return \StructType\DelegaF24
     */
    public function setCodiceIdentificativo($codiceIdentificativo = null)
    {
        // validation for constraint: string
        if (!is_null($codiceIdentificativo) && !is_string($codiceIdentificativo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codiceIdentificativo)), __LINE__);
        }
        if (is_null($codiceIdentificativo) || (is_array($codiceIdentificativo) && empty($codiceIdentificativo))) {
            unset($this->CodiceIdentificativo);
        } else {
            $this->CodiceIdentificativo = $codiceIdentificativo;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\DelegaF24
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get StatoDelega value
     * @return string|null
     */
    public function getStatoDelega()
    {
        return $this->StatoDelega;
    }
    /**
     * Set StatoDelega value
     * @uses \EnumType\StatoDelega::valueIsValid()
     * @uses \EnumType\StatoDelega::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statoDelega
     * @return \StructType\DelegaF24
     */
    public function setStatoDelega($statoDelega = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatoDelega::valueIsValid($statoDelega)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $statoDelega, implode(', ', \EnumType\StatoDelega::getValidValues())), __LINE__);
        }
        $this->StatoDelega = $statoDelega;
        return $this;
    }
    /**
     * Get Valida value
     * @return bool|null
     */
    public function getValida()
    {
        return $this->Valida;
    }
    /**
     * Set Valida value
     * @param bool $valida
     * @return \StructType\DelegaF24
     */
    public function setValida($valida = null)
    {
        // validation for constraint: boolean
        if (!is_null($valida) && !is_bool($valida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($valida)), __LINE__);
        }
        $this->Valida = $valida;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DelegaF24
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
