<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RigaDelegaF24 StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RigaDelegaF24
 * @subpackage Structs
 */
class RigaDelegaF24 extends AbstractStructBase
{
    /**
     * The Acconto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Acconto;
    /**
     * The AnnoDiRiferimento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AnnoDiRiferimento;
    /**
     * The CodiceEnte
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceEnte;
    /**
     * The CodiceTributo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceTributo;
    /**
     * The ImmobiliVariati
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ImmobiliVariati;
    /**
     * The ImportoDetrazioneInCentesimi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ImportoDetrazioneInCentesimi;
    /**
     * The ImportoRigaACreditoInCentesimi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ImportoRigaACreditoInCentesimi;
    /**
     * The ImportoRigaADebitoInCentesimi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ImportoRigaADebitoInCentesimi;
    /**
     * The NumeroImmobili
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroImmobili;
    /**
     * The Rateazione
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Rateazione;
    /**
     * The Ravvedimento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Ravvedimento;
    /**
     * The Saldo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Saldo;
    /**
     * The Sezione
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Sezione;
    /**
     * The Ordine
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Ordine;
    /**
     * Constructor method for RigaDelegaF24
     * @uses RigaDelegaF24::setAcconto()
     * @uses RigaDelegaF24::setAnnoDiRiferimento()
     * @uses RigaDelegaF24::setCodiceEnte()
     * @uses RigaDelegaF24::setCodiceTributo()
     * @uses RigaDelegaF24::setImmobiliVariati()
     * @uses RigaDelegaF24::setImportoDetrazioneInCentesimi()
     * @uses RigaDelegaF24::setImportoRigaACreditoInCentesimi()
     * @uses RigaDelegaF24::setImportoRigaADebitoInCentesimi()
     * @uses RigaDelegaF24::setNumeroImmobili()
     * @uses RigaDelegaF24::setRateazione()
     * @uses RigaDelegaF24::setRavvedimento()
     * @uses RigaDelegaF24::setSaldo()
     * @uses RigaDelegaF24::setSezione()
     * @uses RigaDelegaF24::setOrdine()
     * @param bool $acconto
     * @param int $annoDiRiferimento
     * @param string $codiceEnte
     * @param string $codiceTributo
     * @param bool $immobiliVariati
     * @param int $importoDetrazioneInCentesimi
     * @param int $importoRigaACreditoInCentesimi
     * @param int $importoRigaADebitoInCentesimi
     * @param int $numeroImmobili
     * @param string $rateazione
     * @param bool $ravvedimento
     * @param bool $saldo
     * @param string $sezione
     * @param int $ordine
     */
    public function __construct($acconto = null, $annoDiRiferimento = null, $codiceEnte = null, $codiceTributo = null, $immobiliVariati = null, $importoDetrazioneInCentesimi = null, $importoRigaACreditoInCentesimi = null, $importoRigaADebitoInCentesimi = null, $numeroImmobili = null, $rateazione = null, $ravvedimento = null, $saldo = null, $sezione = null, $ordine = null)
    {
        $this
            ->setAcconto($acconto)
            ->setAnnoDiRiferimento($annoDiRiferimento)
            ->setCodiceEnte($codiceEnte)
            ->setCodiceTributo($codiceTributo)
            ->setImmobiliVariati($immobiliVariati)
            ->setImportoDetrazioneInCentesimi($importoDetrazioneInCentesimi)
            ->setImportoRigaACreditoInCentesimi($importoRigaACreditoInCentesimi)
            ->setImportoRigaADebitoInCentesimi($importoRigaADebitoInCentesimi)
            ->setNumeroImmobili($numeroImmobili)
            ->setRateazione($rateazione)
            ->setRavvedimento($ravvedimento)
            ->setSaldo($saldo)
            ->setSezione($sezione)
            ->setOrdine($ordine);
    }
    /**
     * Get Acconto value
     * @return bool|null
     */
    public function getAcconto()
    {
        return $this->Acconto;
    }
    /**
     * Set Acconto value
     * @param bool $acconto
     * @return \StructType\RigaDelegaF24
     */
    public function setAcconto($acconto = null)
    {
        // validation for constraint: boolean
        if (!is_null($acconto) && !is_bool($acconto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($acconto)), __LINE__);
        }
        $this->Acconto = $acconto;
        return $this;
    }
    /**
     * Get AnnoDiRiferimento value
     * @return int|null
     */
    public function getAnnoDiRiferimento()
    {
        return $this->AnnoDiRiferimento;
    }
    /**
     * Set AnnoDiRiferimento value
     * @param int $annoDiRiferimento
     * @return \StructType\RigaDelegaF24
     */
    public function setAnnoDiRiferimento($annoDiRiferimento = null)
    {
        // validation for constraint: int
        if (!is_null($annoDiRiferimento) && !is_numeric($annoDiRiferimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($annoDiRiferimento)), __LINE__);
        }
        $this->AnnoDiRiferimento = $annoDiRiferimento;
        return $this;
    }
    /**
     * Get CodiceEnte value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceEnte()
    {
        return isset($this->CodiceEnte) ? $this->CodiceEnte : null;
    }
    /**
     * Set CodiceEnte value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceEnte
     * @return \StructType\RigaDelegaF24
     */
    public function setCodiceEnte($codiceEnte = null)
    {
        // validation for constraint: string
        if (!is_null($codiceEnte) && !is_string($codiceEnte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codiceEnte)), __LINE__);
        }
        if (is_null($codiceEnte) || (is_array($codiceEnte) && empty($codiceEnte))) {
            unset($this->CodiceEnte);
        } else {
            $this->CodiceEnte = $codiceEnte;
        }
        return $this;
    }
    /**
     * Get CodiceTributo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceTributo()
    {
        return isset($this->CodiceTributo) ? $this->CodiceTributo : null;
    }
    /**
     * Set CodiceTributo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceTributo
     * @return \StructType\RigaDelegaF24
     */
    public function setCodiceTributo($codiceTributo = null)
    {
        // validation for constraint: string
        if (!is_null($codiceTributo) && !is_string($codiceTributo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codiceTributo)), __LINE__);
        }
        if (is_null($codiceTributo) || (is_array($codiceTributo) && empty($codiceTributo))) {
            unset($this->CodiceTributo);
        } else {
            $this->CodiceTributo = $codiceTributo;
        }
        return $this;
    }
    /**
     * Get ImmobiliVariati value
     * @return bool|null
     */
    public function getImmobiliVariati()
    {
        return $this->ImmobiliVariati;
    }
    /**
     * Set ImmobiliVariati value
     * @param bool $immobiliVariati
     * @return \StructType\RigaDelegaF24
     */
    public function setImmobiliVariati($immobiliVariati = null)
    {
        // validation for constraint: boolean
        if (!is_null($immobiliVariati) && !is_bool($immobiliVariati)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($immobiliVariati)), __LINE__);
        }
        $this->ImmobiliVariati = $immobiliVariati;
        return $this;
    }
    /**
     * Get ImportoDetrazioneInCentesimi value
     * @return int|null
     */
    public function getImportoDetrazioneInCentesimi()
    {
        return $this->ImportoDetrazioneInCentesimi;
    }
    /**
     * Set ImportoDetrazioneInCentesimi value
     * @param int $importoDetrazioneInCentesimi
     * @return \StructType\RigaDelegaF24
     */
    public function setImportoDetrazioneInCentesimi($importoDetrazioneInCentesimi = null)
    {
        // validation for constraint: int
        if (!is_null($importoDetrazioneInCentesimi) && !is_numeric($importoDetrazioneInCentesimi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($importoDetrazioneInCentesimi)), __LINE__);
        }
        $this->ImportoDetrazioneInCentesimi = $importoDetrazioneInCentesimi;
        return $this;
    }
    /**
     * Get ImportoRigaACreditoInCentesimi value
     * @return int|null
     */
    public function getImportoRigaACreditoInCentesimi()
    {
        return $this->ImportoRigaACreditoInCentesimi;
    }
    /**
     * Set ImportoRigaACreditoInCentesimi value
     * @param int $importoRigaACreditoInCentesimi
     * @return \StructType\RigaDelegaF24
     */
    public function setImportoRigaACreditoInCentesimi($importoRigaACreditoInCentesimi = null)
    {
        // validation for constraint: int
        if (!is_null($importoRigaACreditoInCentesimi) && !is_numeric($importoRigaACreditoInCentesimi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($importoRigaACreditoInCentesimi)), __LINE__);
        }
        $this->ImportoRigaACreditoInCentesimi = $importoRigaACreditoInCentesimi;
        return $this;
    }
    /**
     * Get ImportoRigaADebitoInCentesimi value
     * @return int|null
     */
    public function getImportoRigaADebitoInCentesimi()
    {
        return $this->ImportoRigaADebitoInCentesimi;
    }
    /**
     * Set ImportoRigaADebitoInCentesimi value
     * @param int $importoRigaADebitoInCentesimi
     * @return \StructType\RigaDelegaF24
     */
    public function setImportoRigaADebitoInCentesimi($importoRigaADebitoInCentesimi = null)
    {
        // validation for constraint: int
        if (!is_null($importoRigaADebitoInCentesimi) && !is_numeric($importoRigaADebitoInCentesimi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($importoRigaADebitoInCentesimi)), __LINE__);
        }
        $this->ImportoRigaADebitoInCentesimi = $importoRigaADebitoInCentesimi;
        return $this;
    }
    /**
     * Get NumeroImmobili value
     * @return int|null
     */
    public function getNumeroImmobili()
    {
        return $this->NumeroImmobili;
    }
    /**
     * Set NumeroImmobili value
     * @param int $numeroImmobili
     * @return \StructType\RigaDelegaF24
     */
    public function setNumeroImmobili($numeroImmobili = null)
    {
        // validation for constraint: int
        if (!is_null($numeroImmobili) && !is_numeric($numeroImmobili)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroImmobili)), __LINE__);
        }
        $this->NumeroImmobili = $numeroImmobili;
        return $this;
    }
    /**
     * Get Rateazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRateazione()
    {
        return isset($this->Rateazione) ? $this->Rateazione : null;
    }
    /**
     * Set Rateazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rateazione
     * @return \StructType\RigaDelegaF24
     */
    public function setRateazione($rateazione = null)
    {
        // validation for constraint: string
        if (!is_null($rateazione) && !is_string($rateazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateazione)), __LINE__);
        }
        if (is_null($rateazione) || (is_array($rateazione) && empty($rateazione))) {
            unset($this->Rateazione);
        } else {
            $this->Rateazione = $rateazione;
        }
        return $this;
    }
    /**
     * Get Ravvedimento value
     * @return bool|null
     */
    public function getRavvedimento()
    {
        return $this->Ravvedimento;
    }
    /**
     * Set Ravvedimento value
     * @param bool $ravvedimento
     * @return \StructType\RigaDelegaF24
     */
    public function setRavvedimento($ravvedimento = null)
    {
        // validation for constraint: boolean
        if (!is_null($ravvedimento) && !is_bool($ravvedimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ravvedimento)), __LINE__);
        }
        $this->Ravvedimento = $ravvedimento;
        return $this;
    }
    /**
     * Get Saldo value
     * @return bool|null
     */
    public function getSaldo()
    {
        return $this->Saldo;
    }
    /**
     * Set Saldo value
     * @param bool $saldo
     * @return \StructType\RigaDelegaF24
     */
    public function setSaldo($saldo = null)
    {
        // validation for constraint: boolean
        if (!is_null($saldo) && !is_bool($saldo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($saldo)), __LINE__);
        }
        $this->Saldo = $saldo;
        return $this;
    }
    /**
     * Get Sezione value
     * @return string|null
     */
    public function getSezione()
    {
        return $this->Sezione;
    }
    /**
     * Set Sezione value
     * @uses \EnumType\Sezione::valueIsValid()
     * @uses \EnumType\Sezione::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sezione
     * @return \StructType\RigaDelegaF24
     */
    public function setSezione($sezione = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Sezione::valueIsValid($sezione)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sezione, implode(', ', \EnumType\Sezione::getValidValues())), __LINE__);
        }
        $this->Sezione = $sezione;
        return $this;
    }
    /**
     * Get Ordine value
     * @return int|null
     */
    public function getOrdine()
    {
        return $this->Ordine;
    }
    /**
     * Set Ordine value
     * @param int $ordine
     * @return \StructType\RigaDelegaF24
     */
    public function setOrdine($ordine = null)
    {
        // validation for constraint: int
        if (!is_null($ordine) && !is_numeric($ordine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ordine)), __LINE__);
        }
        $this->Ordine = $ordine;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RigaDelegaF24
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
