<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Esito StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Esito
 * @subpackage Structs
 */
class Esito extends AbstractStructBase
{
    /**
     * The ErroriTransazione
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfErrore
     */
    public $ErroriTransazione;
    /**
     * The EsitoTransazione
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EsitoTransazione;
    /**
     * The IdentificativoTransazione
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentificativoTransazione;
    /**
     * The Token
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * The UrlRiepilogoF24
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrlRiepilogoF24;
    /**
     * Constructor method for Esito
     * @uses Esito::setErroriTransazione()
     * @uses Esito::setEsitoTransazione()
     * @uses Esito::setIdentificativoTransazione()
     * @uses Esito::setToken()
     * @uses Esito::setUrlRiepilogoF24()
     * @param \ArrayType\ArrayOfErrore $erroriTransazione
     * @param string $esitoTransazione
     * @param string $identificativoTransazione
     * @param string $token
     * @param string $urlRiepilogoF24
     */
    public function __construct(\ArrayType\ArrayOfErrore $erroriTransazione = null, $esitoTransazione = null, $identificativoTransazione = null, $token = null, $urlRiepilogoF24 = null)
    {
        $this
            ->setErroriTransazione($erroriTransazione)
            ->setEsitoTransazione($esitoTransazione)
            ->setIdentificativoTransazione($identificativoTransazione)
            ->setToken($token)
            ->setUrlRiepilogoF24($urlRiepilogoF24);
    }
    /**
     * Get ErroriTransazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfErrore|null
     */
    public function getErroriTransazione()
    {
        return isset($this->ErroriTransazione) ? $this->ErroriTransazione : null;
    }
    /**
     * Set ErroriTransazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfErrore $erroriTransazione
     * @return \StructType\Esito
     */
    public function setErroriTransazione(\ArrayType\ArrayOfErrore $erroriTransazione = null)
    {
        if (is_null($erroriTransazione) || (is_array($erroriTransazione) && empty($erroriTransazione))) {
            unset($this->ErroriTransazione);
        } else {
            $this->ErroriTransazione = $erroriTransazione;
        }
        return $this;
    }
    /**
     * Get EsitoTransazione value
     * @return string|null
     */
    public function getEsitoTransazione()
    {
        return $this->EsitoTransazione;
    }
    /**
     * Set EsitoTransazione value
     * @uses \EnumType\StatoEsito::valueIsValid()
     * @uses \EnumType\StatoEsito::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $esitoTransazione
     * @return \StructType\Esito
     */
    public function setEsitoTransazione($esitoTransazione = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatoEsito::valueIsValid($esitoTransazione)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $esitoTransazione, implode(', ', \EnumType\StatoEsito::getValidValues())), __LINE__);
        }
        $this->EsitoTransazione = $esitoTransazione;
        return $this;
    }
    /**
     * Get IdentificativoTransazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentificativoTransazione()
    {
        return isset($this->IdentificativoTransazione) ? $this->IdentificativoTransazione : null;
    }
    /**
     * Set IdentificativoTransazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identificativoTransazione
     * @return \StructType\Esito
     */
    public function setIdentificativoTransazione($identificativoTransazione = null)
    {
        // validation for constraint: string
        if (!is_null($identificativoTransazione) && !is_string($identificativoTransazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoTransazione)), __LINE__);
        }
        if (is_null($identificativoTransazione) || (is_array($identificativoTransazione) && empty($identificativoTransazione))) {
            unset($this->IdentificativoTransazione);
        } else {
            $this->IdentificativoTransazione = $identificativoTransazione;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\Esito
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
    /**
     * Get UrlRiepilogoF24 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrlRiepilogoF24()
    {
        return isset($this->UrlRiepilogoF24) ? $this->UrlRiepilogoF24 : null;
    }
    /**
     * Set UrlRiepilogoF24 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urlRiepilogoF24
     * @return \StructType\Esito
     */
    public function setUrlRiepilogoF24($urlRiepilogoF24 = null)
    {
        // validation for constraint: string
        if (!is_null($urlRiepilogoF24) && !is_string($urlRiepilogoF24)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($urlRiepilogoF24)), __LINE__);
        }
        if (is_null($urlRiepilogoF24) || (is_array($urlRiepilogoF24) && empty($urlRiepilogoF24))) {
            unset($this->UrlRiepilogoF24);
        } else {
            $this->UrlRiepilogoF24 = $urlRiepilogoF24;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Esito
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
