<?php

namespace EnumType;

/**
 * This class stands for Sesso EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Sesso
 * @subpackage Enumerations
 */
class Sesso
{
    /**
     * Constant for value 'PersonaNonFisica'
     * @return string 'PersonaNonFisica'
     */
    const VALUE_PERSONA_NON_FISICA = 'PersonaNonFisica';
    /**
     * Constant for value 'Maschio'
     * @return string 'Maschio'
     */
    const VALUE_MASCHIO = 'Maschio';
    /**
     * Constant for value 'Femmina'
     * @return string 'Femmina'
     */
    const VALUE_FEMMINA = 'Femmina';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PERSONA_NON_FISICA
     * @uses self::VALUE_MASCHIO
     * @uses self::VALUE_FEMMINA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PERSONA_NON_FISICA,
            self::VALUE_MASCHIO,
            self::VALUE_FEMMINA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
