<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contribuente StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Contribuente
 * @subpackage Structs
 */
class Contribuente extends AbstractStructBase
{
    /**
     * The Cellulare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cellulare;
    /**
     * The CodiceFiscalePartitaIva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceFiscalePartitaIva;
    /**
     * The CodiceFiscalePartitaIvaCoobbligato
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceFiscalePartitaIvaCoobbligato;
    /**
     * The CodiceIdentificativoCoobbligato
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceIdentificativoCoobbligato;
    /**
     * The CognomeDenominazione
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CognomeDenominazione;
    /**
     * The ComuneOStatoEsteroDiNascita
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComuneOStatoEsteroDiNascita;
    /**
     * The DataNascita
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataNascita;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Indirizzo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Indirizzo;
    /**
     * The Nome
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nome;
    /**
     * The ProvinciaDiNascita
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProvinciaDiNascita;
    /**
     * The Sesso
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Sesso;
    /**
     * Constructor method for Contribuente
     * @uses Contribuente::setCellulare()
     * @uses Contribuente::setCodiceFiscalePartitaIva()
     * @uses Contribuente::setCodiceFiscalePartitaIvaCoobbligato()
     * @uses Contribuente::setCodiceIdentificativoCoobbligato()
     * @uses Contribuente::setCognomeDenominazione()
     * @uses Contribuente::setComuneOStatoEsteroDiNascita()
     * @uses Contribuente::setDataNascita()
     * @uses Contribuente::setEmail()
     * @uses Contribuente::setIndirizzo()
     * @uses Contribuente::setNome()
     * @uses Contribuente::setProvinciaDiNascita()
     * @uses Contribuente::setSesso()
     * @param string $cellulare
     * @param string $codiceFiscalePartitaIva
     * @param string $codiceFiscalePartitaIvaCoobbligato
     * @param string $codiceIdentificativoCoobbligato
     * @param string $cognomeDenominazione
     * @param string $comuneOStatoEsteroDiNascita
     * @param string $dataNascita
     * @param string $email
     * @param string $indirizzo
     * @param string $nome
     * @param string $provinciaDiNascita
     * @param string $sesso
     */
    public function __construct($cellulare = null, $codiceFiscalePartitaIva = null, $codiceFiscalePartitaIvaCoobbligato = null, $codiceIdentificativoCoobbligato = null, $cognomeDenominazione = null, $comuneOStatoEsteroDiNascita = null, $dataNascita = null, $email = null, $indirizzo = null, $nome = null, $provinciaDiNascita = null, $sesso = null)
    {
        $this
            ->setCellulare($cellulare)
            ->setCodiceFiscalePartitaIva($codiceFiscalePartitaIva)
            ->setCodiceFiscalePartitaIvaCoobbligato($codiceFiscalePartitaIvaCoobbligato)
            ->setCodiceIdentificativoCoobbligato($codiceIdentificativoCoobbligato)
            ->setCognomeDenominazione($cognomeDenominazione)
            ->setComuneOStatoEsteroDiNascita($comuneOStatoEsteroDiNascita)
            ->setDataNascita($dataNascita)
            ->setEmail($email)
            ->setIndirizzo($indirizzo)
            ->setNome($nome)
            ->setProvinciaDiNascita($provinciaDiNascita)
            ->setSesso($sesso);
    }
    /**
     * Get Cellulare value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCellulare()
    {
        return isset($this->Cellulare) ? $this->Cellulare : null;
    }
    /**
     * Set Cellulare value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cellulare
     * @return \StructType\Contribuente
     */
    public function setCellulare($cellulare = null)
    {
        // validation for constraint: string
        if (!is_null($cellulare) && !is_string($cellulare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cellulare)), __LINE__);
        }
        if (is_null($cellulare) || (is_array($cellulare) && empty($cellulare))) {
            unset($this->Cellulare);
        } else {
            $this->Cellulare = $cellulare;
        }
        return $this;
    }
    /**
     * Get CodiceFiscalePartitaIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceFiscalePartitaIva()
    {
        return isset($this->CodiceFiscalePartitaIva) ? $this->CodiceFiscalePartitaIva : null;
    }
    /**
     * Set CodiceFiscalePartitaIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceFiscalePartitaIva
     * @return \StructType\Contribuente
     */
    public function setCodiceFiscalePartitaIva($codiceFiscalePartitaIva = null)
    {
        // validation for constraint: string
        if (!is_null($codiceFiscalePartitaIva) && !is_string($codiceFiscalePartitaIva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codiceFiscalePartitaIva)), __LINE__);
        }
        if (is_null($codiceFiscalePartitaIva) || (is_array($codiceFiscalePartitaIva) && empty($codiceFiscalePartitaIva))) {
            unset($this->CodiceFiscalePartitaIva);
        } else {
            $this->CodiceFiscalePartitaIva = $codiceFiscalePartitaIva;
        }
        return $this;
    }
    /**
     * Get CodiceFiscalePartitaIvaCoobbligato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceFiscalePartitaIvaCoobbligato()
    {
        return isset($this->CodiceFiscalePartitaIvaCoobbligato) ? $this->CodiceFiscalePartitaIvaCoobbligato : null;
    }
    /**
     * Set CodiceFiscalePartitaIvaCoobbligato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceFiscalePartitaIvaCoobbligato
     * @return \StructType\Contribuente
     */
    public function setCodiceFiscalePartitaIvaCoobbligato($codiceFiscalePartitaIvaCoobbligato = null)
    {
        // validation for constraint: string
        if (!is_null($codiceFiscalePartitaIvaCoobbligato) && !is_string($codiceFiscalePartitaIvaCoobbligato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codiceFiscalePartitaIvaCoobbligato)), __LINE__);
        }
        if (is_null($codiceFiscalePartitaIvaCoobbligato) || (is_array($codiceFiscalePartitaIvaCoobbligato) && empty($codiceFiscalePartitaIvaCoobbligato))) {
            unset($this->CodiceFiscalePartitaIvaCoobbligato);
        } else {
            $this->CodiceFiscalePartitaIvaCoobbligato = $codiceFiscalePartitaIvaCoobbligato;
        }
        return $this;
    }
    /**
     * Get CodiceIdentificativoCoobbligato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceIdentificativoCoobbligato()
    {
        return isset($this->CodiceIdentificativoCoobbligato) ? $this->CodiceIdentificativoCoobbligato : null;
    }
    /**
     * Set CodiceIdentificativoCoobbligato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceIdentificativoCoobbligato
     * @return \StructType\Contribuente
     */
    public function setCodiceIdentificativoCoobbligato($codiceIdentificativoCoobbligato = null)
    {
        // validation for constraint: string
        if (!is_null($codiceIdentificativoCoobbligato) && !is_string($codiceIdentificativoCoobbligato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codiceIdentificativoCoobbligato)), __LINE__);
        }
        if (is_null($codiceIdentificativoCoobbligato) || (is_array($codiceIdentificativoCoobbligato) && empty($codiceIdentificativoCoobbligato))) {
            unset($this->CodiceIdentificativoCoobbligato);
        } else {
            $this->CodiceIdentificativoCoobbligato = $codiceIdentificativoCoobbligato;
        }
        return $this;
    }
    /**
     * Get CognomeDenominazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCognomeDenominazione()
    {
        return isset($this->CognomeDenominazione) ? $this->CognomeDenominazione : null;
    }
    /**
     * Set CognomeDenominazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cognomeDenominazione
     * @return \StructType\Contribuente
     */
    public function setCognomeDenominazione($cognomeDenominazione = null)
    {
        // validation for constraint: string
        if (!is_null($cognomeDenominazione) && !is_string($cognomeDenominazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cognomeDenominazione)), __LINE__);
        }
        if (is_null($cognomeDenominazione) || (is_array($cognomeDenominazione) && empty($cognomeDenominazione))) {
            unset($this->CognomeDenominazione);
        } else {
            $this->CognomeDenominazione = $cognomeDenominazione;
        }
        return $this;
    }
    /**
     * Get ComuneOStatoEsteroDiNascita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComuneOStatoEsteroDiNascita()
    {
        return isset($this->ComuneOStatoEsteroDiNascita) ? $this->ComuneOStatoEsteroDiNascita : null;
    }
    /**
     * Set ComuneOStatoEsteroDiNascita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comuneOStatoEsteroDiNascita
     * @return \StructType\Contribuente
     */
    public function setComuneOStatoEsteroDiNascita($comuneOStatoEsteroDiNascita = null)
    {
        // validation for constraint: string
        if (!is_null($comuneOStatoEsteroDiNascita) && !is_string($comuneOStatoEsteroDiNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comuneOStatoEsteroDiNascita)), __LINE__);
        }
        if (is_null($comuneOStatoEsteroDiNascita) || (is_array($comuneOStatoEsteroDiNascita) && empty($comuneOStatoEsteroDiNascita))) {
            unset($this->ComuneOStatoEsteroDiNascita);
        } else {
            $this->ComuneOStatoEsteroDiNascita = $comuneOStatoEsteroDiNascita;
        }
        return $this;
    }
    /**
     * Get DataNascita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataNascita()
    {
        return isset($this->DataNascita) ? $this->DataNascita : null;
    }
    /**
     * Set DataNascita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataNascita
     * @return \StructType\Contribuente
     */
    public function setDataNascita($dataNascita = null)
    {
        // validation for constraint: string
        if (!is_null($dataNascita) && !is_string($dataNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataNascita)), __LINE__);
        }
        if (is_null($dataNascita) || (is_array($dataNascita) && empty($dataNascita))) {
            unset($this->DataNascita);
        } else {
            $this->DataNascita = $dataNascita;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\Contribuente
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Indirizzo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndirizzo()
    {
        return isset($this->Indirizzo) ? $this->Indirizzo : null;
    }
    /**
     * Set Indirizzo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $indirizzo
     * @return \StructType\Contribuente
     */
    public function setIndirizzo($indirizzo = null)
    {
        // validation for constraint: string
        if (!is_null($indirizzo) && !is_string($indirizzo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($indirizzo)), __LINE__);
        }
        if (is_null($indirizzo) || (is_array($indirizzo) && empty($indirizzo))) {
            unset($this->Indirizzo);
        } else {
            $this->Indirizzo = $indirizzo;
        }
        return $this;
    }
    /**
     * Get Nome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNome()
    {
        return isset($this->Nome) ? $this->Nome : null;
    }
    /**
     * Set Nome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nome
     * @return \StructType\Contribuente
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nome)), __LINE__);
        }
        if (is_null($nome) || (is_array($nome) && empty($nome))) {
            unset($this->Nome);
        } else {
            $this->Nome = $nome;
        }
        return $this;
    }
    /**
     * Get ProvinciaDiNascita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvinciaDiNascita()
    {
        return isset($this->ProvinciaDiNascita) ? $this->ProvinciaDiNascita : null;
    }
    /**
     * Set ProvinciaDiNascita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provinciaDiNascita
     * @return \StructType\Contribuente
     */
    public function setProvinciaDiNascita($provinciaDiNascita = null)
    {
        // validation for constraint: string
        if (!is_null($provinciaDiNascita) && !is_string($provinciaDiNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provinciaDiNascita)), __LINE__);
        }
        if (is_null($provinciaDiNascita) || (is_array($provinciaDiNascita) && empty($provinciaDiNascita))) {
            unset($this->ProvinciaDiNascita);
        } else {
            $this->ProvinciaDiNascita = $provinciaDiNascita;
        }
        return $this;
    }
    /**
     * Get Sesso value
     * @return string|null
     */
    public function getSesso()
    {
        return $this->Sesso;
    }
    /**
     * Set Sesso value
     * @uses \EnumType\Sesso::valueIsValid()
     * @uses \EnumType\Sesso::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sesso
     * @return \StructType\Contribuente
     */
    public function setSesso($sesso = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Sesso::valueIsValid($sesso)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sesso, implode(', ', \EnumType\Sesso::getValidValues())), __LINE__);
        }
        $this->Sesso = $sesso;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Contribuente
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
