<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Avvia ServiceType
 * @subpackage Services
 */
class Avvia extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AvviaTransazionePagamentoSpontaneo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AvviaTransazionePagamentoSpontaneo $parameters
     * @return \StructType\AvviaTransazionePagamentoSpontaneoResponse|bool
     */
    public function AvviaTransazionePagamentoSpontaneo(\StructType\AvviaTransazionePagamentoSpontaneo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AvviaTransazionePagamentoSpontaneo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * AvviaTransazionePagamentoPredeterminato
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AvviaTransazionePagamentoPredeterminato $parameters
     * @return \StructType\AvviaTransazionePagamentoPredeterminatoResponse|bool
     */
    public function AvviaTransazionePagamentoPredeterminato(\StructType\AvviaTransazionePagamentoPredeterminato $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AvviaTransazionePagamentoPredeterminato($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AvviaTransazionePagamentoPredeterminatoResponse|\StructType\AvviaTransazionePagamentoSpontaneoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
