<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xmlImportDati StructType
 * @subpackage Structs
 */
class XmlImportDati extends AbstractStructBase
{
    /**
     * The codice
     * @var string
     */
    public $codice;
    /**
     * The prodotto
     * @var string
     */
    public $prodotto;
    /**
     * The movimento
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\MovimentoBean[]
     */
    public $movimento;
    /**
     * Constructor method for xmlImportDati
     * @uses XmlImportDati::setCodice()
     * @uses XmlImportDati::setProdotto()
     * @uses XmlImportDati::setMovimento()
     * @param string $codice
     * @param string $prodotto
     * @param \StructType\MovimentoBean[] $movimento
     */
    public function __construct($codice = null, $prodotto = null, array $movimento = array())
    {
        $this
            ->setCodice($codice)
            ->setProdotto($prodotto)
            ->setMovimento($movimento);
    }
    /**
     * Get codice value
     * @return string|null
     */
    public function getCodice()
    {
        return $this->codice;
    }
    /**
     * Set codice value
     * @param string $codice
     * @return \StructType\XmlImportDati
     */
    public function setCodice($codice = null)
    {
        // validation for constraint: string
        if (!is_null($codice) && !is_string($codice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codice)), __LINE__);
        }
        $this->codice = $codice;
        return $this;
    }
    /**
     * Get prodotto value
     * @return string|null
     */
    public function getProdotto()
    {
        return $this->prodotto;
    }
    /**
     * Set prodotto value
     * @param string $prodotto
     * @return \StructType\XmlImportDati
     */
    public function setProdotto($prodotto = null)
    {
        // validation for constraint: string
        if (!is_null($prodotto) && !is_string($prodotto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prodotto)), __LINE__);
        }
        $this->prodotto = $prodotto;
        return $this;
    }
    /**
     * Get movimento value
     * @return \StructType\MovimentoBean[]|null
     */
    public function getMovimento()
    {
        return $this->movimento;
    }
    /**
     * Set movimento value
     * @throws \InvalidArgumentException
     * @param \StructType\MovimentoBean[] $movimento
     * @return \StructType\XmlImportDati
     */
    public function setMovimento(array $movimento = array())
    {
        foreach ($movimento as $xmlImportDatiMovimentoItem) {
            // validation for constraint: itemType
            if (!$xmlImportDatiMovimentoItem instanceof \StructType\MovimentoBean) {
                throw new \InvalidArgumentException(sprintf('The movimento property can only contain items of \StructType\MovimentoBean, "%s" given', is_object($xmlImportDatiMovimentoItem) ? get_class($xmlImportDatiMovimentoItem) : gettype($xmlImportDatiMovimentoItem)), __LINE__);
            }
        }
        $this->movimento = $movimento;
        return $this;
    }
    /**
     * Add item to movimento value
     * @throws \InvalidArgumentException
     * @param \StructType\MovimentoBean $item
     * @return \StructType\XmlImportDati
     */
    public function addToMovimento(\StructType\MovimentoBean $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MovimentoBean) {
            throw new \InvalidArgumentException(sprintf('The movimento property can only contain items of \StructType\MovimentoBean, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->movimento[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XmlImportDati
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
