<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rettifiche StructType
 * @subpackage Structs
 */
class Rettifiche extends AbstractStructBase
{
    /**
     * The eliminazione
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EliminazioneBean[]
     */
    public $eliminazione;
    /**
     * Constructor method for rettifiche
     * @uses Rettifiche::setEliminazione()
     * @param \StructType\EliminazioneBean[] $eliminazione
     */
    public function __construct(array $eliminazione = array())
    {
        $this
            ->setEliminazione($eliminazione);
    }
    /**
     * Get eliminazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EliminazioneBean[]|null
     */
    public function getEliminazione()
    {
        return isset($this->eliminazione) ? $this->eliminazione : null;
    }
    /**
     * Set eliminazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EliminazioneBean[] $eliminazione
     * @return \StructType\Rettifiche
     */
    public function setEliminazione(array $eliminazione = array())
    {
        foreach ($eliminazione as $rettificheEliminazioneItem) {
            // validation for constraint: itemType
            if (!$rettificheEliminazioneItem instanceof \StructType\EliminazioneBean) {
                throw new \InvalidArgumentException(sprintf('The eliminazione property can only contain items of \StructType\EliminazioneBean, "%s" given', is_object($rettificheEliminazioneItem) ? get_class($rettificheEliminazioneItem) : gettype($rettificheEliminazioneItem)), __LINE__);
            }
        }
        if (is_null($eliminazione) || (is_array($eliminazione) && empty($eliminazione))) {
            unset($this->eliminazione);
        } else {
            $this->eliminazione = $eliminazione;
        }
        return $this;
    }
    /**
     * Add item to eliminazione value
     * @throws \InvalidArgumentException
     * @param \StructType\EliminazioneBean $item
     * @return \StructType\Rettifiche
     */
    public function addToEliminazione(\StructType\EliminazioneBean $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EliminazioneBean) {
            throw new \InvalidArgumentException(sprintf('The eliminazione property can only contain items of \StructType\EliminazioneBean, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->eliminazione[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Rettifiche
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
