<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for retifiche StructType
 * @subpackage Structs
 */
class Retifiche extends AbstractStructBase
{
    /**
     * The eliminazione
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Risultato[]
     */
    public $eliminazione;
    /**
     * Constructor method for retifiche
     * @uses Retifiche::setEliminazione()
     * @param \StructType\Risultato[] $eliminazione
     */
    public function __construct(array $eliminazione = array())
    {
        $this
            ->setEliminazione($eliminazione);
    }
    /**
     * Get eliminazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Risultato[]|null
     */
    public function getEliminazione()
    {
        return isset($this->eliminazione) ? $this->eliminazione : null;
    }
    /**
     * Set eliminazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Risultato[] $eliminazione
     * @return \StructType\Retifiche
     */
    public function setEliminazione(array $eliminazione = array())
    {
        foreach ($eliminazione as $retificheEliminazioneItem) {
            // validation for constraint: itemType
            if (!$retificheEliminazioneItem instanceof \StructType\Risultato) {
                throw new \InvalidArgumentException(sprintf('The eliminazione property can only contain items of \StructType\Risultato, "%s" given', is_object($retificheEliminazioneItem) ? get_class($retificheEliminazioneItem) : gettype($retificheEliminazioneItem)), __LINE__);
            }
        }
        if (is_null($eliminazione) || (is_array($eliminazione) && empty($eliminazione))) {
            unset($this->eliminazione);
        } else {
            $this->eliminazione = $eliminazione;
        }
        return $this;
    }
    /**
     * Add item to eliminazione value
     * @throws \InvalidArgumentException
     * @param \StructType\Risultato $item
     * @return \StructType\Retifiche
     */
    public function addToEliminazione(\StructType\Risultato $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Risultato) {
            throw new \InvalidArgumentException(sprintf('The eliminazione property can only contain items of \StructType\Risultato, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->eliminazione[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Retifiche
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
