<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for prenotazioni StructType
 * @subpackage Structs
 */
class Prenotazioni extends AbstractStructBase
{
    /**
     * The prenotazione
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PrenotazioneBean[]
     */
    public $prenotazione;
    /**
     * Constructor method for prenotazioni
     * @uses Prenotazioni::setPrenotazione()
     * @param \StructType\PrenotazioneBean[] $prenotazione
     */
    public function __construct(array $prenotazione = array())
    {
        $this
            ->setPrenotazione($prenotazione);
    }
    /**
     * Get prenotazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PrenotazioneBean[]|null
     */
    public function getPrenotazione()
    {
        return isset($this->prenotazione) ? $this->prenotazione : null;
    }
    /**
     * Set prenotazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PrenotazioneBean[] $prenotazione
     * @return \StructType\Prenotazioni
     */
    public function setPrenotazione(array $prenotazione = array())
    {
        foreach ($prenotazione as $prenotazioniPrenotazioneItem) {
            // validation for constraint: itemType
            if (!$prenotazioniPrenotazioneItem instanceof \StructType\PrenotazioneBean) {
                throw new \InvalidArgumentException(sprintf('The prenotazione property can only contain items of \StructType\PrenotazioneBean, "%s" given', is_object($prenotazioniPrenotazioneItem) ? get_class($prenotazioniPrenotazioneItem) : gettype($prenotazioniPrenotazioneItem)), __LINE__);
            }
        }
        if (is_null($prenotazione) || (is_array($prenotazione) && empty($prenotazione))) {
            unset($this->prenotazione);
        } else {
            $this->prenotazione = $prenotazione;
        }
        return $this;
    }
    /**
     * Add item to prenotazione value
     * @throws \InvalidArgumentException
     * @param \StructType\PrenotazioneBean $item
     * @return \StructType\Prenotazioni
     */
    public function addToPrenotazione(\StructType\PrenotazioneBean $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PrenotazioneBean) {
            throw new \InvalidArgumentException(sprintf('The prenotazione property can only contain items of \StructType\PrenotazioneBean, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->prenotazione[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Prenotazioni
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
