<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for prenotazioneBean StructType
 * @subpackage Structs
 */
class PrenotazioneBean extends AbstractStructBase
{
    /**
     * The idswh
     * @var string
     */
    public $idswh;
    /**
     * The arrivo
     * @var string
     */
    public $arrivo;
    /**
     * The partenza
     * @var string
     */
    public $partenza;
    /**
     * The ospiti
     * @var string
     */
    public $ospiti;
    /**
     * The camere
     * @var string
     */
    public $camere;
    /**
     * The prezzo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $prezzo;
    /**
     * The canaleprenotazione
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $canaleprenotazione;
    /**
     * Constructor method for prenotazioneBean
     * @uses PrenotazioneBean::setIdswh()
     * @uses PrenotazioneBean::setArrivo()
     * @uses PrenotazioneBean::setPartenza()
     * @uses PrenotazioneBean::setOspiti()
     * @uses PrenotazioneBean::setCamere()
     * @uses PrenotazioneBean::setPrezzo()
     * @uses PrenotazioneBean::setCanaleprenotazione()
     * @param string $idswh
     * @param string $arrivo
     * @param string $partenza
     * @param string $ospiti
     * @param string $camere
     * @param string $prezzo
     * @param string $canaleprenotazione
     */
    public function __construct($idswh = null, $arrivo = null, $partenza = null, $ospiti = null, $camere = null, $prezzo = null, $canaleprenotazione = null)
    {
        $this
            ->setIdswh($idswh)
            ->setArrivo($arrivo)
            ->setPartenza($partenza)
            ->setOspiti($ospiti)
            ->setCamere($camere)
            ->setPrezzo($prezzo)
            ->setCanaleprenotazione($canaleprenotazione);
    }
    /**
     * Get idswh value
     * @return string|null
     */
    public function getIdswh()
    {
        return $this->idswh;
    }
    /**
     * Set idswh value
     * @param string $idswh
     * @return \StructType\PrenotazioneBean
     */
    public function setIdswh($idswh = null)
    {
        // validation for constraint: string
        if (!is_null($idswh) && !is_string($idswh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idswh)), __LINE__);
        }
        $this->idswh = $idswh;
        return $this;
    }
    /**
     * Get arrivo value
     * @return string|null
     */
    public function getArrivo()
    {
        return $this->arrivo;
    }
    /**
     * Set arrivo value
     * @param string $arrivo
     * @return \StructType\PrenotazioneBean
     */
    public function setArrivo($arrivo = null)
    {
        // validation for constraint: string
        if (!is_null($arrivo) && !is_string($arrivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivo)), __LINE__);
        }
        $this->arrivo = $arrivo;
        return $this;
    }
    /**
     * Get partenza value
     * @return string|null
     */
    public function getPartenza()
    {
        return $this->partenza;
    }
    /**
     * Set partenza value
     * @param string $partenza
     * @return \StructType\PrenotazioneBean
     */
    public function setPartenza($partenza = null)
    {
        // validation for constraint: string
        if (!is_null($partenza) && !is_string($partenza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partenza)), __LINE__);
        }
        $this->partenza = $partenza;
        return $this;
    }
    /**
     * Get ospiti value
     * @return string|null
     */
    public function getOspiti()
    {
        return $this->ospiti;
    }
    /**
     * Set ospiti value
     * @param string $ospiti
     * @return \StructType\PrenotazioneBean
     */
    public function setOspiti($ospiti = null)
    {
        // validation for constraint: string
        if (!is_null($ospiti) && !is_string($ospiti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ospiti)), __LINE__);
        }
        $this->ospiti = $ospiti;
        return $this;
    }
    /**
     * Get camere value
     * @return string|null
     */
    public function getCamere()
    {
        return $this->camere;
    }
    /**
     * Set camere value
     * @param string $camere
     * @return \StructType\PrenotazioneBean
     */
    public function setCamere($camere = null)
    {
        // validation for constraint: string
        if (!is_null($camere) && !is_string($camere)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($camere)), __LINE__);
        }
        $this->camere = $camere;
        return $this;
    }
    /**
     * Get prezzo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrezzo()
    {
        return isset($this->prezzo) ? $this->prezzo : null;
    }
    /**
     * Set prezzo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prezzo
     * @return \StructType\PrenotazioneBean
     */
    public function setPrezzo($prezzo = null)
    {
        // validation for constraint: string
        if (!is_null($prezzo) && !is_string($prezzo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prezzo)), __LINE__);
        }
        if (is_null($prezzo) || (is_array($prezzo) && empty($prezzo))) {
            unset($this->prezzo);
        } else {
            $this->prezzo = $prezzo;
        }
        return $this;
    }
    /**
     * Get canaleprenotazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCanaleprenotazione()
    {
        return isset($this->canaleprenotazione) ? $this->canaleprenotazione : null;
    }
    /**
     * Set canaleprenotazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $canaleprenotazione
     * @return \StructType\PrenotazioneBean
     */
    public function setCanaleprenotazione($canaleprenotazione = null)
    {
        // validation for constraint: string
        if (!is_null($canaleprenotazione) && !is_string($canaleprenotazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($canaleprenotazione)), __LINE__);
        }
        if (is_null($canaleprenotazione) || (is_array($canaleprenotazione) && empty($canaleprenotazione))) {
            unset($this->canaleprenotazione);
        } else {
            $this->canaleprenotazione = $canaleprenotazione;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrenotazioneBean
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
