<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for partenze StructType
 * @subpackage Structs
 */
class Partenze extends AbstractStructBase
{
    /**
     * The partenza
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PartenzaBean[]
     */
    public $partenza;
    /**
     * Constructor method for partenze
     * @uses Partenze::setPartenza()
     * @param \StructType\PartenzaBean[] $partenza
     */
    public function __construct(array $partenza = array())
    {
        $this
            ->setPartenza($partenza);
    }
    /**
     * Get partenza value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PartenzaBean[]|null
     */
    public function getPartenza()
    {
        return isset($this->partenza) ? $this->partenza : null;
    }
    /**
     * Set partenza value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PartenzaBean[] $partenza
     * @return \StructType\Partenze
     */
    public function setPartenza(array $partenza = array())
    {
        foreach ($partenza as $partenzePartenzaItem) {
            // validation for constraint: itemType
            if (!$partenzePartenzaItem instanceof \StructType\PartenzaBean) {
                throw new \InvalidArgumentException(sprintf('The partenza property can only contain items of \StructType\PartenzaBean, "%s" given', is_object($partenzePartenzaItem) ? get_class($partenzePartenzaItem) : gettype($partenzePartenzaItem)), __LINE__);
            }
        }
        if (is_null($partenza) || (is_array($partenza) && empty($partenza))) {
            unset($this->partenza);
        } else {
            $this->partenza = $partenza;
        }
        return $this;
    }
    /**
     * Add item to partenza value
     * @throws \InvalidArgumentException
     * @param \StructType\PartenzaBean $item
     * @return \StructType\Partenze
     */
    public function addToPartenza(\StructType\PartenzaBean $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartenzaBean) {
            throw new \InvalidArgumentException(sprintf('The partenza property can only contain items of \StructType\PartenzaBean, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->partenza[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Partenze
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
