<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for movimentoBean StructType
 * @subpackage Structs
 */
class MovimentoBean extends AbstractStructBase
{
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $data;
    /**
     * The struttura
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StrutturaBean
     */
    public $struttura;
    /**
     * The arrivi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Arrivi
     */
    public $arrivi;
    /**
     * The partenze
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Partenze
     */
    public $partenze;
    /**
     * The prenotazioni
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Prenotazioni
     */
    public $prenotazioni;
    /**
     * The rettifiche
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Rettifiche
     */
    public $rettifiche;
    /**
     * Constructor method for movimentoBean
     * @uses MovimentoBean::setData()
     * @uses MovimentoBean::setStruttura()
     * @uses MovimentoBean::setArrivi()
     * @uses MovimentoBean::setPartenze()
     * @uses MovimentoBean::setPrenotazioni()
     * @uses MovimentoBean::setRettifiche()
     * @param string $data
     * @param \StructType\StrutturaBean $struttura
     * @param \StructType\Arrivi $arrivi
     * @param \StructType\Partenze $partenze
     * @param \StructType\Prenotazioni $prenotazioni
     * @param \StructType\Rettifiche $rettifiche
     */
    public function __construct($data = null, \StructType\StrutturaBean $struttura = null, \StructType\Arrivi $arrivi = null, \StructType\Partenze $partenze = null, \StructType\Prenotazioni $prenotazioni = null, \StructType\Rettifiche $rettifiche = null)
    {
        $this
            ->setData($data)
            ->setStruttura($struttura)
            ->setArrivi($arrivi)
            ->setPartenze($partenze)
            ->setPrenotazioni($prenotazioni)
            ->setRettifiche($rettifiche);
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \StructType\MovimentoBean
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($data)), __LINE__);
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Get struttura value
     * @return \StructType\StrutturaBean|null
     */
    public function getStruttura()
    {
        return $this->struttura;
    }
    /**
     * Set struttura value
     * @param \StructType\StrutturaBean $struttura
     * @return \StructType\MovimentoBean
     */
    public function setStruttura(\StructType\StrutturaBean $struttura = null)
    {
        $this->struttura = $struttura;
        return $this;
    }
    /**
     * Get arrivi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Arrivi|null
     */
    public function getArrivi()
    {
        return isset($this->arrivi) ? $this->arrivi : null;
    }
    /**
     * Set arrivi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Arrivi $arrivi
     * @return \StructType\MovimentoBean
     */
    public function setArrivi(\StructType\Arrivi $arrivi = null)
    {
        if (is_null($arrivi) || (is_array($arrivi) && empty($arrivi))) {
            unset($this->arrivi);
        } else {
            $this->arrivi = $arrivi;
        }
        return $this;
    }
    /**
     * Get partenze value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Partenze|null
     */
    public function getPartenze()
    {
        return isset($this->partenze) ? $this->partenze : null;
    }
    /**
     * Set partenze value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Partenze $partenze
     * @return \StructType\MovimentoBean
     */
    public function setPartenze(\StructType\Partenze $partenze = null)
    {
        if (is_null($partenze) || (is_array($partenze) && empty($partenze))) {
            unset($this->partenze);
        } else {
            $this->partenze = $partenze;
        }
        return $this;
    }
    /**
     * Get prenotazioni value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Prenotazioni|null
     */
    public function getPrenotazioni()
    {
        return isset($this->prenotazioni) ? $this->prenotazioni : null;
    }
    /**
     * Set prenotazioni value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Prenotazioni $prenotazioni
     * @return \StructType\MovimentoBean
     */
    public function setPrenotazioni(\StructType\Prenotazioni $prenotazioni = null)
    {
        if (is_null($prenotazioni) || (is_array($prenotazioni) && empty($prenotazioni))) {
            unset($this->prenotazioni);
        } else {
            $this->prenotazioni = $prenotazioni;
        }
        return $this;
    }
    /**
     * Get rettifiche value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Rettifiche|null
     */
    public function getRettifiche()
    {
        return isset($this->rettifiche) ? $this->rettifiche : null;
    }
    /**
     * Set rettifiche value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Rettifiche $rettifiche
     * @return \StructType\MovimentoBean
     */
    public function setRettifiche(\StructType\Rettifiche $rettifiche = null)
    {
        if (is_null($rettifiche) || (is_array($rettifiche) && empty($rettifiche))) {
            unset($this->rettifiche);
        } else {
            $this->rettifiche = $rettifiche;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MovimentoBean
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
