<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for arrivi StructType
 * @subpackage Structs
 */
class Arrivi extends AbstractStructBase
{
    /**
     * The arrivo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ArrivoBean[]
     */
    public $arrivo;
    /**
     * Constructor method for arrivi
     * @uses Arrivi::setArrivo()
     * @param \StructType\ArrivoBean[] $arrivo
     */
    public function __construct(array $arrivo = array())
    {
        $this
            ->setArrivo($arrivo);
    }
    /**
     * Get arrivo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ArrivoBean[]|null
     */
    public function getArrivo()
    {
        return isset($this->arrivo) ? $this->arrivo : null;
    }
    /**
     * Set arrivo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ArrivoBean[] $arrivo
     * @return \StructType\Arrivi
     */
    public function setArrivo(array $arrivo = array())
    {
        foreach ($arrivo as $arriviArrivoItem) {
            // validation for constraint: itemType
            if (!$arriviArrivoItem instanceof \StructType\ArrivoBean) {
                throw new \InvalidArgumentException(sprintf('The arrivo property can only contain items of \StructType\ArrivoBean, "%s" given', is_object($arriviArrivoItem) ? get_class($arriviArrivoItem) : gettype($arriviArrivoItem)), __LINE__);
            }
        }
        if (is_null($arrivo) || (is_array($arrivo) && empty($arrivo))) {
            unset($this->arrivo);
        } else {
            $this->arrivo = $arrivo;
        }
        return $this;
    }
    /**
     * Add item to arrivo value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrivoBean $item
     * @return \StructType\Arrivi
     */
    public function addToArrivo(\StructType\ArrivoBean $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArrivoBean) {
            throw new \InvalidArgumentException(sprintf('The arrivo property can only contain items of \StructType\ArrivoBean, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->arrivo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Arrivi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
