<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for risultatoGiorno StructType
 * @subpackage Structs
 */
class RisultatoGiorno extends AbstractStructBase
{
    /**
     * The arrivi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Arrivi
     */
    public $arrivi;
    /**
     * The partenze
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Partenze
     */
    public $partenze;
    /**
     * The prenotazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Prenotazioni
     */
    public $prenotazioni;
    /**
     * The retifiche
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Retifiche
     */
    public $retifiche;
    /**
     * Constructor method for risultatoGiorno
     * @uses RisultatoGiorno::setArrivi()
     * @uses RisultatoGiorno::setPartenze()
     * @uses RisultatoGiorno::setPrenotazioni()
     * @uses RisultatoGiorno::setRetifiche()
     * @param \StructType\Arrivi $arrivi
     * @param \StructType\Partenze $partenze
     * @param \StructType\Prenotazioni $prenotazioni
     * @param \StructType\Retifiche $retifiche
     */
    public function __construct(\StructType\Arrivi $arrivi = null, \StructType\Partenze $partenze = null, \StructType\Prenotazioni $prenotazioni = null, \StructType\Retifiche $retifiche = null)
    {
        $this
            ->setArrivi($arrivi)
            ->setPartenze($partenze)
            ->setPrenotazioni($prenotazioni)
            ->setRetifiche($retifiche);
    }
    /**
     * Get arrivi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Arrivi|null
     */
    public function getArrivi()
    {
        return isset($this->arrivi) ? $this->arrivi : null;
    }
    /**
     * Set arrivi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Arrivi $arrivi
     * @return \StructType\RisultatoGiorno
     */
    public function setArrivi(\StructType\Arrivi $arrivi = null)
    {
        if (is_null($arrivi) || (is_array($arrivi) && empty($arrivi))) {
            unset($this->arrivi);
        } else {
            $this->arrivi = $arrivi;
        }
        return $this;
    }
    /**
     * Get partenze value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Partenze|null
     */
    public function getPartenze()
    {
        return isset($this->partenze) ? $this->partenze : null;
    }
    /**
     * Set partenze value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Partenze $partenze
     * @return \StructType\RisultatoGiorno
     */
    public function setPartenze(\StructType\Partenze $partenze = null)
    {
        if (is_null($partenze) || (is_array($partenze) && empty($partenze))) {
            unset($this->partenze);
        } else {
            $this->partenze = $partenze;
        }
        return $this;
    }
    /**
     * Get prenotazioni value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Prenotazioni|null
     */
    public function getPrenotazioni()
    {
        return isset($this->prenotazioni) ? $this->prenotazioni : null;
    }
    /**
     * Set prenotazioni value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Prenotazioni $prenotazioni
     * @return \StructType\RisultatoGiorno
     */
    public function setPrenotazioni(\StructType\Prenotazioni $prenotazioni = null)
    {
        if (is_null($prenotazioni) || (is_array($prenotazioni) && empty($prenotazioni))) {
            unset($this->prenotazioni);
        } else {
            $this->prenotazioni = $prenotazioni;
        }
        return $this;
    }
    /**
     * Get retifiche value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Retifiche|null
     */
    public function getRetifiche()
    {
        return isset($this->retifiche) ? $this->retifiche : null;
    }
    /**
     * Set retifiche value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Retifiche $retifiche
     * @return \StructType\RisultatoGiorno
     */
    public function setRetifiche(\StructType\Retifiche $retifiche = null)
    {
        if (is_null($retifiche) || (is_array($retifiche) && empty($retifiche))) {
            unset($this->retifiche);
        } else {
            $this->retifiche = $retifiche;
        }
        return $this;
    }
}
