<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for prenotazioni StructType
 * @subpackage Structs
 */
class Prenotazioni extends AbstractStructBase
{
    /**
     * The prenotazione
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PrenotazioneBean[]
     */
    public $prenotazione;
    /**
     * Constructor method for prenotazioni
     * @uses Prenotazioni::setPrenotazione()
     * @param \StructType\PrenotazioneBean[] $prenotazione
     */
    public function __construct(array $prenotazione = array())
    {
        $this
            ->setPrenotazione($prenotazione);
    }
    /**
     * Get prenotazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PrenotazioneBean[]|null
     */
    public function getPrenotazione()
    {
        return isset($this->prenotazione) ? $this->prenotazione : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPrenotazione method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrenotazione method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrenotazioneForArrayConstraintsFromSetPrenotazione(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prenotazioniPrenotazioneItem) {
            // validation for constraint: itemType
            if (!$prenotazioniPrenotazioneItem instanceof \StructType\PrenotazioneBean) {
                $invalidValues[] = is_object($prenotazioniPrenotazioneItem) ? get_class($prenotazioniPrenotazioneItem) : sprintf('%s(%s)', gettype($prenotazioniPrenotazioneItem), var_export($prenotazioniPrenotazioneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The prenotazione property can only contain items of type \StructType\PrenotazioneBean, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set prenotazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PrenotazioneBean[] $prenotazione
     * @return \StructType\Prenotazioni
     */
    public function setPrenotazione(array $prenotazione = array())
    {
        // validation for constraint: array
        if ('' !== ($prenotazioneArrayErrorMessage = self::validatePrenotazioneForArrayConstraintsFromSetPrenotazione($prenotazione))) {
            throw new \InvalidArgumentException($prenotazioneArrayErrorMessage, __LINE__);
        }
        if (is_null($prenotazione) || (is_array($prenotazione) && empty($prenotazione))) {
            unset($this->prenotazione);
        } else {
            $this->prenotazione = $prenotazione;
        }
        return $this;
    }
    /**
     * Add item to prenotazione value
     * @throws \InvalidArgumentException
     * @param \StructType\PrenotazioneBean $item
     * @return \StructType\Prenotazioni
     */
    public function addToPrenotazione(\StructType\PrenotazioneBean $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PrenotazioneBean) {
            throw new \InvalidArgumentException(sprintf('The prenotazione property can only contain items of type \StructType\PrenotazioneBean, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->prenotazione[] = $item;
        return $this;
    }
}
