<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for arrivi StructType
 * @subpackage Structs
 */
class Arrivi extends AbstractStructBase
{
    /**
     * The arrivo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ArrivoBean[]
     */
    public $arrivo;
    /**
     * Constructor method for arrivi
     * @uses Arrivi::setArrivo()
     * @param \StructType\ArrivoBean[] $arrivo
     */
    public function __construct(array $arrivo = array())
    {
        $this
            ->setArrivo($arrivo);
    }
    /**
     * Get arrivo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ArrivoBean[]|null
     */
    public function getArrivo()
    {
        return isset($this->arrivo) ? $this->arrivo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setArrivo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArrivo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArrivoForArrayConstraintsFromSetArrivo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arriviArrivoItem) {
            // validation for constraint: itemType
            if (!$arriviArrivoItem instanceof \StructType\ArrivoBean) {
                $invalidValues[] = is_object($arriviArrivoItem) ? get_class($arriviArrivoItem) : sprintf('%s(%s)', gettype($arriviArrivoItem), var_export($arriviArrivoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The arrivo property can only contain items of type \StructType\ArrivoBean, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set arrivo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ArrivoBean[] $arrivo
     * @return \StructType\Arrivi
     */
    public function setArrivo(array $arrivo = array())
    {
        // validation for constraint: array
        if ('' !== ($arrivoArrayErrorMessage = self::validateArrivoForArrayConstraintsFromSetArrivo($arrivo))) {
            throw new \InvalidArgumentException($arrivoArrayErrorMessage, __LINE__);
        }
        if (is_null($arrivo) || (is_array($arrivo) && empty($arrivo))) {
            unset($this->arrivo);
        } else {
            $this->arrivo = $arrivo;
        }
        return $this;
    }
    /**
     * Add item to arrivo value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrivoBean $item
     * @return \StructType\Arrivi
     */
    public function addToArrivo(\StructType\ArrivoBean $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArrivoBean) {
            throw new \InvalidArgumentException(sprintf('The arrivo property can only contain items of type \StructType\ArrivoBean, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->arrivo[] = $item;
        return $this;
    }
}
