<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Invia ServiceType
 * @subpackage Services
 */
class Invia extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named inviaMovimentazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InviaMovimentazione $parameters
     * @return \StructType\InviaMovimentazioneResponse|bool
     */
    public function inviaMovimentazione(\StructType\InviaMovimentazione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->inviaMovimentazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InviaMovimentazioneResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
