<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \ebay\ClassMap::get(),
);
/**
 * Samples for Add ServiceType
 */
$add = new \ebay\ServiceType\Add($options);
$add->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for AddDispute operation/method
 */
if ($add->AddDispute(new \ebay\StructType\AddDisputeRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDisputeResponse operation/method
 */
if ($add->AddDisputeResponse(new \ebay\StructType\AddDisputeResponseRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddFixedPriceItem operation/method
 */
if ($add->AddFixedPriceItem(new \ebay\StructType\AddFixedPriceItemRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddItem operation/method
 */
if ($add->AddItem(new \ebay\StructType\AddItemRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddItemFromSellingManagerTemplate operation/method
 */
if ($add->AddItemFromSellingManagerTemplate(new \ebay\StructType\AddItemFromSellingManagerTemplateRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddItems operation/method
 */
if ($add->AddItems(new \ebay\StructType\AddItemsRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMemberMessageAAQToPartner operation/method
 */
if ($add->AddMemberMessageAAQToPartner(new \ebay\StructType\AddMemberMessageAAQToPartnerRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMemberMessageRTQ operation/method
 */
if ($add->AddMemberMessageRTQ(new \ebay\StructType\AddMemberMessageRTQRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMemberMessagesAAQToBidder operation/method
 */
if ($add->AddMemberMessagesAAQToBidder(new \ebay\StructType\AddMemberMessagesAAQToBidderRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddOrder operation/method
 */
if ($add->AddOrder(new \ebay\StructType\AddOrderRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSecondChanceItem operation/method
 */
if ($add->AddSecondChanceItem(new \ebay\StructType\AddSecondChanceItemRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSellingManagerInventoryFolder operation/method
 */
if ($add->AddSellingManagerInventoryFolder(new \ebay\StructType\AddSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSellingManagerProduct operation/method
 */
if ($add->AddSellingManagerProduct(new \ebay\StructType\AddSellingManagerProductRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSellingManagerTemplate operation/method
 */
if ($add->AddSellingManagerTemplate(new \ebay\StructType\AddSellingManagerTemplateRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddToItemDescription operation/method
 */
if ($add->AddToItemDescription(new \ebay\StructType\AddToItemDescriptionRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddToWatchList operation/method
 */
if ($add->AddToWatchList(new \ebay\StructType\AddToWatchListRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTransactionConfirmationItem operation/method
 */
if ($add->AddTransactionConfirmationItem(new \ebay\StructType\AddTransactionConfirmationItemRequestType()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Complete ServiceType
 */
$complete = new \ebay\ServiceType\Complete($options);
$complete->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for CompleteSale operation/method
 */
if ($complete->CompleteSale(new \ebay\StructType\CompleteSaleRequestType()) !== false) {
    print_r($complete->getResult());
} else {
    print_r($complete->getLastError());
}
/**
 * Samples for Confirm ServiceType
 */
$confirm = new \ebay\ServiceType\Confirm($options);
$confirm->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for ConfirmIdentity operation/method
 */
if ($confirm->ConfirmIdentity(new \ebay\StructType\ConfirmIdentityRequestType()) !== false) {
    print_r($confirm->getResult());
} else {
    print_r($confirm->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ebay\ServiceType\Delete($options);
$delete->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for DeleteMyMessages operation/method
 */
if ($delete->DeleteMyMessages(new \ebay\StructType\DeleteMyMessagesRequestType()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSellingManagerInventoryFolder operation/method
 */
if ($delete->DeleteSellingManagerInventoryFolder(new \ebay\StructType\DeleteSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSellingManagerItemAutomationRule operation/method
 */
if ($delete->DeleteSellingManagerItemAutomationRule(new \ebay\StructType\DeleteSellingManagerItemAutomationRuleRequestType()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSellingManagerProduct operation/method
 */
if ($delete->DeleteSellingManagerProduct(new \ebay\StructType\DeleteSellingManagerProductRequestType()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSellingManagerTemplate operation/method
 */
if ($delete->DeleteSellingManagerTemplate(new \ebay\StructType\DeleteSellingManagerTemplateRequestType()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSellingManagerTemplateAutomationRule operation/method
 */
if ($delete->DeleteSellingManagerTemplateAutomationRule(new \ebay\StructType\DeleteSellingManagerTemplateAutomationRuleRequestType()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Disable ServiceType
 */
$disable = new \ebay\ServiceType\Disable($options);
$disable->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for DisableUnpaidItemAssistance operation/method
 */
if ($disable->DisableUnpaidItemAssistance(new \ebay\StructType\DisableUnpaidItemAssistanceRequestType()) !== false) {
    print_r($disable->getResult());
} else {
    print_r($disable->getLastError());
}
/**
 * Samples for End ServiceType
 */
$end = new \ebay\ServiceType\End($options);
$end->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for EndFixedPriceItem operation/method
 */
if ($end->EndFixedPriceItem(new \ebay\StructType\EndFixedPriceItemRequestType()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Sample call for EndItem operation/method
 */
if ($end->EndItem(new \ebay\StructType\EndItemRequestType()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Sample call for EndItems operation/method
 */
if ($end->EndItems(new \ebay\StructType\EndItemsRequestType()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Samples for Extend ServiceType
 */
$extend = new \ebay\ServiceType\Extend($options);
$extend->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for ExtendSiteHostedPictures operation/method
 */
if ($extend->ExtendSiteHostedPictures(new \ebay\StructType\ExtendSiteHostedPicturesRequestType()) !== false) {
    print_r($extend->getResult());
} else {
    print_r($extend->getLastError());
}
/**
 * Samples for Fetch ServiceType
 */
$fetch = new \ebay\ServiceType\Fetch($options);
$fetch->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for FetchToken operation/method
 */
if ($fetch->FetchToken(new \ebay\StructType\FetchTokenRequestType()) !== false) {
    print_r($fetch->getResult());
} else {
    print_r($fetch->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ebay\ServiceType\Get($options);
$get->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for GetAccount operation/method
 */
if ($get->GetAccount(new \ebay\StructType\GetAccountRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAdFormatLeads operation/method
 */
if ($get->GetAdFormatLeads(new \ebay\StructType\GetAdFormatLeadsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllBidders operation/method
 */
if ($get->GetAllBidders(new \ebay\StructType\GetAllBiddersRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetApiAccessRules operation/method
 */
if ($get->GetApiAccessRules(new \ebay\StructType\GetApiAccessRulesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBestOffers operation/method
 */
if ($get->GetBestOffers(new \ebay\StructType\GetBestOffersRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBidderList operation/method
 */
if ($get->GetBidderList(new \ebay\StructType\GetBidderListRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCategories operation/method
 */
if ($get->GetCategories(new \ebay\StructType\GetCategoriesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCategoryFeatures operation/method
 */
if ($get->GetCategoryFeatures(new \ebay\StructType\GetCategoryFeaturesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCategoryMappings operation/method
 */
if ($get->GetCategoryMappings(new \ebay\StructType\GetCategoryMappingsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCategorySpecifics operation/method
 */
if ($get->GetCategorySpecifics(new \ebay\StructType\GetCategorySpecificsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetChallengeToken operation/method
 */
if ($get->GetChallengeToken(new \ebay\StructType\GetChallengeTokenRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCharities operation/method
 */
if ($get->GetCharities(new \ebay\StructType\GetCharitiesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientAlertsAuthToken operation/method
 */
if ($get->GetClientAlertsAuthToken(new \ebay\StructType\GetClientAlertsAuthTokenRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContextualKeywords operation/method
 */
if ($get->GetContextualKeywords(new \ebay\StructType\GetContextualKeywordsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDescriptionTemplates operation/method
 */
if ($get->GetDescriptionTemplates(new \ebay\StructType\GetDescriptionTemplatesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDispute operation/method
 */
if ($get->GetDispute(new \ebay\StructType\GetDisputeRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFeedback operation/method
 */
if ($get->GetFeedback(new \ebay\StructType\GetFeedbackRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItem operation/method
 */
if ($get->GetItem(new \ebay\StructType\GetItemRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItemShipping operation/method
 */
if ($get->GetItemShipping(new \ebay\StructType\GetItemShippingRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItemTransactions operation/method
 */
if ($get->GetItemTransactions(new \ebay\StructType\GetItemTransactionsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItemsAwaitingFeedback operation/method
 */
if ($get->GetItemsAwaitingFeedback(new \ebay\StructType\GetItemsAwaitingFeedbackRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMemberMessages operation/method
 */
if ($get->GetMemberMessages(new \ebay\StructType\GetMemberMessagesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMessagePreferences operation/method
 */
if ($get->GetMessagePreferences(new \ebay\StructType\GetMessagePreferencesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMyMessages operation/method
 */
if ($get->GetMyMessages(new \ebay\StructType\GetMyMessagesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMyeBayBuying operation/method
 */
if ($get->GetMyeBayBuying(new \ebay\StructType\GetMyeBayBuyingRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMyeBayReminders operation/method
 */
if ($get->GetMyeBayReminders(new \ebay\StructType\GetMyeBayRemindersRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMyeBaySelling operation/method
 */
if ($get->GetMyeBaySelling(new \ebay\StructType\GetMyeBaySellingRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNotificationPreferences operation/method
 */
if ($get->GetNotificationPreferences(new \ebay\StructType\GetNotificationPreferencesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNotificationsUsage operation/method
 */
if ($get->GetNotificationsUsage(new \ebay\StructType\GetNotificationsUsageRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrderTransactions operation/method
 */
if ($get->GetOrderTransactions(new \ebay\StructType\GetOrderTransactionsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrders operation/method
 */
if ($get->GetOrders(new \ebay\StructType\GetOrdersRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPromotionalSaleDetails operation/method
 */
if ($get->GetPromotionalSaleDetails(new \ebay\StructType\GetPromotionalSaleDetailsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellerDashboard operation/method
 */
if ($get->GetSellerDashboard(new \ebay\StructType\GetSellerDashboardRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellerEvents operation/method
 */
if ($get->GetSellerEvents(new \ebay\StructType\GetSellerEventsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellerList operation/method
 */
if ($get->GetSellerList(new \ebay\StructType\GetSellerListRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellerPayments operation/method
 */
if ($get->GetSellerPayments(new \ebay\StructType\GetSellerPaymentsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellerTransactions operation/method
 */
if ($get->GetSellerTransactions(new \ebay\StructType\GetSellerTransactionsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerAlerts operation/method
 */
if ($get->GetSellingManagerAlerts(new \ebay\StructType\GetSellingManagerAlertsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerEmailLog operation/method
 */
if ($get->GetSellingManagerEmailLog(new \ebay\StructType\GetSellingManagerEmailLogRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerInventory operation/method
 */
if ($get->GetSellingManagerInventory(new \ebay\StructType\GetSellingManagerInventoryRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerInventoryFolder operation/method
 */
if ($get->GetSellingManagerInventoryFolder(new \ebay\StructType\GetSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerItemAutomationRule operation/method
 */
if ($get->GetSellingManagerItemAutomationRule(new \ebay\StructType\GetSellingManagerItemAutomationRuleRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerSaleRecord operation/method
 */
if ($get->GetSellingManagerSaleRecord(new \ebay\StructType\GetSellingManagerSaleRecordRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerSoldListings operation/method
 */
if ($get->GetSellingManagerSoldListings(new \ebay\StructType\GetSellingManagerSoldListingsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerTemplateAutomationRule operation/method
 */
if ($get->GetSellingManagerTemplateAutomationRule(new \ebay\StructType\GetSellingManagerTemplateAutomationRuleRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellingManagerTemplates operation/method
 */
if ($get->GetSellingManagerTemplates(new \ebay\StructType\GetSellingManagerTemplatesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSessionID operation/method
 */
if ($get->GetSessionID(new \ebay\StructType\GetSessionIDRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetShippingDiscountProfiles operation/method
 */
if ($get->GetShippingDiscountProfiles(new \ebay\StructType\GetShippingDiscountProfilesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStore operation/method
 */
if ($get->GetStore(new \ebay\StructType\GetStoreRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStoreCategoryUpdateStatus operation/method
 */
if ($get->GetStoreCategoryUpdateStatus(new \ebay\StructType\GetStoreCategoryUpdateStatusRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStoreCustomPage operation/method
 */
if ($get->GetStoreCustomPage(new \ebay\StructType\GetStoreCustomPageRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStoreOptions operation/method
 */
if ($get->GetStoreOptions(new \ebay\StructType\GetStoreOptionsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStorePreferences operation/method
 */
if ($get->GetStorePreferences(new \ebay\StructType\GetStorePreferencesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSuggestedCategories operation/method
 */
if ($get->GetSuggestedCategories(new \ebay\StructType\GetSuggestedCategoriesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTaxTable operation/method
 */
if ($get->GetTaxTable(new \ebay\StructType\GetTaxTableRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTokenStatus operation/method
 */
if ($get->GetTokenStatus(new \ebay\StructType\GetTokenStatusRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUser operation/method
 */
if ($get->GetUser(new \ebay\StructType\GetUserRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserContactDetails operation/method
 */
if ($get->GetUserContactDetails(new \ebay\StructType\GetUserContactDetailsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserDisputes operation/method
 */
if ($get->GetUserDisputes(new \ebay\StructType\GetUserDisputesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserPreferences operation/method
 */
if ($get->GetUserPreferences(new \ebay\StructType\GetUserPreferencesRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVeROReasonCodeDetails operation/method
 */
if ($get->GetVeROReasonCodeDetails(new \ebay\StructType\GetVeROReasonCodeDetailsRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVeROReportStatus operation/method
 */
if ($get->GetVeROReportStatus(new \ebay\StructType\GetVeROReportStatusRequestType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Gete ServiceType
 */
$gete = new \ebay\ServiceType\Gete($options);
$gete->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for GeteBayDetails operation/method
 */
if ($gete->GeteBayDetails(new \ebay\StructType\GeteBayDetailsRequestType()) !== false) {
    print_r($gete->getResult());
} else {
    print_r($gete->getLastError());
}
/**
 * Sample call for GeteBayOfficialTime operation/method
 */
if ($gete->GeteBayOfficialTime(new \ebay\StructType\GeteBayOfficialTimeRequestType()) !== false) {
    print_r($gete->getResult());
} else {
    print_r($gete->getLastError());
}
/**
 * Samples for Issue ServiceType
 */
$issue = new \ebay\ServiceType\Issue($options);
$issue->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for IssueRefund operation/method
 */
if ($issue->IssueRefund(new \ebay\StructType\IssueRefundRequestType()) !== false) {
    print_r($issue->getResult());
} else {
    print_r($issue->getLastError());
}
/**
 * Samples for Leave ServiceType
 */
$leave = new \ebay\ServiceType\Leave($options);
$leave->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for LeaveFeedback operation/method
 */
if ($leave->LeaveFeedback(new \ebay\StructType\LeaveFeedbackRequestType()) !== false) {
    print_r($leave->getResult());
} else {
    print_r($leave->getLastError());
}
/**
 * Samples for Move ServiceType
 */
$move = new \ebay\ServiceType\Move($options);
$move->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for MoveSellingManagerInventoryFolder operation/method
 */
if ($move->MoveSellingManagerInventoryFolder(new \ebay\StructType\MoveSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Samples for Place ServiceType
 */
$place = new \ebay\ServiceType\Place($options);
$place->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for PlaceOffer operation/method
 */
if ($place->PlaceOffer(new \ebay\StructType\PlaceOfferRequestType()) !== false) {
    print_r($place->getResult());
} else {
    print_r($place->getLastError());
}
/**
 * Samples for Relist ServiceType
 */
$relist = new \ebay\ServiceType\Relist($options);
$relist->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for RelistFixedPriceItem operation/method
 */
if ($relist->RelistFixedPriceItem(new \ebay\StructType\RelistFixedPriceItemRequestType()) !== false) {
    print_r($relist->getResult());
} else {
    print_r($relist->getLastError());
}
/**
 * Sample call for RelistItem operation/method
 */
if ($relist->RelistItem(new \ebay\StructType\RelistItemRequestType()) !== false) {
    print_r($relist->getResult());
} else {
    print_r($relist->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ebay\ServiceType\Remove($options);
$remove->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for RemoveFromWatchList operation/method
 */
if ($remove->RemoveFromWatchList(new \ebay\StructType\RemoveFromWatchListRequestType()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Respond ServiceType
 */
$respond = new \ebay\ServiceType\Respond($options);
$respond->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for RespondToBestOffer operation/method
 */
if ($respond->RespondToBestOffer(new \ebay\StructType\RespondToBestOfferRequestType()) !== false) {
    print_r($respond->getResult());
} else {
    print_r($respond->getLastError());
}
/**
 * Sample call for RespondToFeedback operation/method
 */
if ($respond->RespondToFeedback(new \ebay\StructType\RespondToFeedbackRequestType()) !== false) {
    print_r($respond->getResult());
} else {
    print_r($respond->getLastError());
}
/**
 * Samples for Revise ServiceType
 */
$revise = new \ebay\ServiceType\Revise($options);
$revise->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for ReviseCheckoutStatus operation/method
 */
if ($revise->ReviseCheckoutStatus(new \ebay\StructType\ReviseCheckoutStatusRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseFixedPriceItem operation/method
 */
if ($revise->ReviseFixedPriceItem(new \ebay\StructType\ReviseFixedPriceItemRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseInventoryStatus operation/method
 */
if ($revise->ReviseInventoryStatus(new \ebay\StructType\ReviseInventoryStatusRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseItem operation/method
 */
if ($revise->ReviseItem(new \ebay\StructType\ReviseItemRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseMyMessages operation/method
 */
if ($revise->ReviseMyMessages(new \ebay\StructType\ReviseMyMessagesRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseMyMessagesFolders operation/method
 */
if ($revise->ReviseMyMessagesFolders(new \ebay\StructType\ReviseMyMessagesFoldersRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseSellingManagerInventoryFolder operation/method
 */
if ($revise->ReviseSellingManagerInventoryFolder(new \ebay\StructType\ReviseSellingManagerInventoryFolderRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseSellingManagerProduct operation/method
 */
if ($revise->ReviseSellingManagerProduct(new \ebay\StructType\ReviseSellingManagerProductRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseSellingManagerSaleRecord operation/method
 */
if ($revise->ReviseSellingManagerSaleRecord(new \ebay\StructType\ReviseSellingManagerSaleRecordRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Sample call for ReviseSellingManagerTemplate operation/method
 */
if ($revise->ReviseSellingManagerTemplate(new \ebay\StructType\ReviseSellingManagerTemplateRequestType()) !== false) {
    print_r($revise->getResult());
} else {
    print_r($revise->getLastError());
}
/**
 * Samples for Revoke ServiceType
 */
$revoke = new \ebay\ServiceType\Revoke($options);
$revoke->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for RevokeToken operation/method
 */
if ($revoke->RevokeToken(new \ebay\StructType\RevokeTokenRequestType()) !== false) {
    print_r($revoke->getResult());
} else {
    print_r($revoke->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \ebay\ServiceType\Save($options);
$save->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for SaveItemToSellingManagerTemplate operation/method
 */
if ($save->SaveItemToSellingManagerTemplate(new \ebay\StructType\SaveItemToSellingManagerTemplateRequestType()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Seller ServiceType
 */
$seller = new \ebay\ServiceType\Seller($options);
$seller->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for SellerReverseDispute operation/method
 */
if ($seller->SellerReverseDispute(new \ebay\StructType\SellerReverseDisputeRequestType()) !== false) {
    print_r($seller->getResult());
} else {
    print_r($seller->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ebay\ServiceType\Send($options);
$send->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for SendInvoice operation/method
 */
if ($send->SendInvoice(new \ebay\StructType\SendInvoiceRequestType()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ebay\ServiceType\Set($options);
$set->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for SetMessagePreferences operation/method
 */
if ($set->SetMessagePreferences(new \ebay\StructType\SetMessagePreferencesRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetNotificationPreferences operation/method
 */
if ($set->SetNotificationPreferences(new \ebay\StructType\SetNotificationPreferencesRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetPromotionalSale operation/method
 */
if ($set->SetPromotionalSale(new \ebay\StructType\SetPromotionalSaleRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetPromotionalSaleListings operation/method
 */
if ($set->SetPromotionalSaleListings(new \ebay\StructType\SetPromotionalSaleListingsRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSellingManagerFeedbackOptions operation/method
 */
if ($set->SetSellingManagerFeedbackOptions(new \ebay\StructType\SetSellingManagerFeedbackOptionsRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSellingManagerItemAutomationRule operation/method
 */
if ($set->SetSellingManagerItemAutomationRule(new \ebay\StructType\SetSellingManagerItemAutomationRuleRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSellingManagerTemplateAutomationRule operation/method
 */
if ($set->SetSellingManagerTemplateAutomationRule(new \ebay\StructType\SetSellingManagerTemplateAutomationRuleRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetShippingDiscountProfiles operation/method
 */
if ($set->SetShippingDiscountProfiles(new \ebay\StructType\SetShippingDiscountProfilesRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetStore operation/method
 */
if ($set->SetStore(new \ebay\StructType\SetStoreRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetStoreCategories operation/method
 */
if ($set->SetStoreCategories(new \ebay\StructType\SetStoreCategoriesRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetStoreCustomPage operation/method
 */
if ($set->SetStoreCustomPage(new \ebay\StructType\SetStoreCustomPageRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetStorePreferences operation/method
 */
if ($set->SetStorePreferences(new \ebay\StructType\SetStorePreferencesRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetTaxTable operation/method
 */
if ($set->SetTaxTable(new \ebay\StructType\SetTaxTableRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetUserNotes operation/method
 */
if ($set->SetUserNotes(new \ebay\StructType\SetUserNotesRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetUserPreferences operation/method
 */
if ($set->SetUserPreferences(new \ebay\StructType\SetUserPreferencesRequestType()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \ebay\ServiceType\Upload($options);
$upload->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for UploadSiteHostedPictures operation/method
 */
if ($upload->UploadSiteHostedPictures(new \ebay\StructType\UploadSiteHostedPicturesRequestType()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ebay\ServiceType\Validate($options);
$validate->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for ValidateChallengeInput operation/method
 */
if ($validate->ValidateChallengeInput(new \ebay\StructType\ValidateChallengeInputRequestType()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateTestUserRegistration operation/method
 */
if ($validate->ValidateTestUserRegistration(new \ebay\StructType\ValidateTestUserRegistrationRequestType()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Ve ServiceType
 */
$ve = new \ebay\ServiceType\Ve($options);
$ve->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for VeROReportItems operation/method
 */
if ($ve->VeROReportItems(new \ebay\StructType\VeROReportItemsRequestType()) !== false) {
    print_r($ve->getResult());
} else {
    print_r($ve->getLastError());
}
/**
 * Samples for Verify ServiceType
 */
$verify = new \ebay\ServiceType\Verify($options);
$verify->setSoapHeaderRequesterCredentials($RequesterCredentials);
/**
 * Sample call for VerifyAddFixedPriceItem operation/method
 */
if ($verify->VerifyAddFixedPriceItem(new \ebay\StructType\VerifyAddFixedPriceItemRequestType()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Sample call for VerifyAddItem operation/method
 */
if ($verify->VerifyAddItem(new \ebay\StructType\VerifyAddItemRequestType()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Sample call for VerifyAddSecondChanceItem operation/method
 */
if ($verify->VerifyAddSecondChanceItem(new \ebay\StructType\VerifyAddSecondChanceItemRequestType()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Sample call for VerifyRelistItem operation/method
 */
if ($verify->VerifyRelistItem(new \ebay\StructType\VerifyRelistItemRequestType()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
