<?php

namespace ebay\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingServiceDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Details about a specific shipping service.
 * @subpackage Structs
 * @date 2017-04-07 16
 */
class ShippingServiceDetailsType extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Display string that applications can use to present a list of shipping service options in a more user-friendly format (such as in a drop-down list).
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ExpeditedService
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the shipping service is an expedited shipping service. See Enabling Get It Fast. Only returned for sites for which the Get It Fast feature is enabled and only if true.
     * - minOccurs: 0
     * @var bool
     */
    public $ExpeditedService;
    /**
     * The InternationalService
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the shipping service is an international shipping service. An international shipping service option is required if an item is being shipped from one country (origin) to another (destination).
     * - minOccurs: 0
     * @var bool
     */
    public $InternationalService;
    /**
     * The ShippingService
     * Meta informations extracted from the WSDL
     * - documentation: The name of shipping service option. The ShippingServiceDetails.<strong>ValidForSellingFlow</strong> flag must also be present and <code>true</code>. Otherwise, that particular shipping service option is no longer valid and cannot be
     * offered to buyers through a listing.
     * - minOccurs: 0
     * @var string
     */
    public $ShippingService;
    /**
     * The ShippingServiceID
     * Meta informations extracted from the WSDL
     * - documentation: Numeric identifier. A value greater than 50000 represents an international shipping service (confirmed by InternationalShippingService being true). Some applications use this ID to look up shipping services more efficiently. Also
     * useful for applications that have migrated from the legacy XML API.
     * - minOccurs: 0
     * @var int
     */
    public $ShippingServiceID;
    /**
     * The ShippingTimeMax
     * Meta informations extracted from the WSDL
     * - documentation: The maximum guaranteed number of days the shipping carrier will take to ship an item (not including the time it takes the seller to deliver the item to the shipping carrier). Always returned when ExpeditedService is true or if
     * defined for a particular service. See Enabling Get It Fast feature.
     * - minOccurs: 0
     * @var int
     */
    public $ShippingTimeMax;
    /**
     * The ShippingTimeMin
     * Meta informations extracted from the WSDL
     * - documentation: The minimum guaranteed number of days the shipping carrier will take to ship an item (not including the time it takes the seller to deliver the item to the shipping carrier). Always returned when ExpeditedService is true or if
     * defined for a particular service. See Enabling Get It Fast feature.
     * - minOccurs: 0
     * @var int
     */
    public $ShippingTimeMin;
    /**
     * The ShippingServiceCode
     * Meta informations extracted from the WSDL
     * - documentation: For future use.
     * - minOccurs: 0
     * @var string
     */
    public $ShippingServiceCode;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - documentation: The types of shipping that this shipping service supports.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ServiceType;
    /**
     * The ShippingPackage
     * Meta informations extracted from the WSDL
     * - documentation: The kinds of packages supported by this shipping service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ShippingPackage;
    /**
     * The DimensionsRequired
     * Meta informations extracted from the WSDL
     * - documentation: This field is only returned if the shipping service option requires that package dimensions are provided by the seller. If it is returned, it is always returned as 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $DimensionsRequired;
    /**
     * The ValidForSellingFlow
     * Meta informations extracted from the WSDL
     * - documentation: If this field is returned as 'true', the shipping service option can be used in a Add/Revise/Relist API call. If this field is returned as 'false', the shipping service option is not currently supported and cannot be used in a
     * Add/Revise/Relist API call.
     * - minOccurs: 0
     * @var bool
     */
    public $ValidForSellingFlow;
    /**
     * The SurchargeApplicable
     * Meta informations extracted from the WSDL
     * - documentation: True if a surcharge applies for any region that this service ships to.
     * - minOccurs: 0
     * @var bool
     */
    public $SurchargeApplicable;
    /**
     * The ShippingCarrier
     * Meta informations extracted from the WSDL
     * - documentation: The codes for carriers supported by this shipping service. <br/><br/> <span class="tablenote"> <strong>Note:</strong> Commonly used shipping carriers can be found by calling <b>GeteBayDetails</b> with <b>DetailName</b> set to
     * <code>ShippingCarrierDetails</code> and examining the returned <b>ShippingCarrierDetails.ShippingCarrier</b> field. However, as of release 961, <a
     * href="http://developer.ebay.com/Devzone/XML/docs/Reference/eBay/types/ShippingCarrierCodeType.html">ShippingCarrierCodeType</a> contains the most current list of shipping carriers and the countries served by each carrier. The <b>GeteBayDetails</b>
     * call is being updated to provide the same information more conveniently in an upcoming release. </span>
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ShippingCarrier;
    /**
     * The CODService
     * Meta informations extracted from the WSDL
     * - documentation: This flag is returned as 'true' if the corresponding <b>ShippingServiceDetails.ShippingService</b> value is a COD (Cash-On-Delivery) service. <br/><br/> COD shipping services are not supported by all sites. This field is only
     * returned if 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $CODService;
    /**
     * The DeprecationDetails
     * Meta informations extracted from the WSDL
     * - documentation: A mechanism by which details about deprecation of a shipping service is announced. See also MappedToShippingServiceID. If this container is empty, it means that there is no mapping for this shipping service and that the shipping
     * service will be dropped from the listing without an accompanying warning message from the eBay API.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\AnnouncementMessageType[]
     */
    public $DeprecationDetails;
    /**
     * The MappedToShippingServiceID
     * Meta informations extracted from the WSDL
     * - documentation: The ID of another shipping service that will be used when a shipping service is deprecated. See also DeprecationDetails.
     * - minOccurs: 0
     * @var int
     */
    public $MappedToShippingServiceID;
    /**
     * The CostGroupFlat
     * Meta informations extracted from the WSDL
     * - documentation: If returned, this is the shipping service group to which the shipping service belongs. Valid values are found in CostGroupFlatCodeType.
     * - minOccurs: 0
     * @var string
     */
    public $CostGroupFlat;
    /**
     * The ShippingServicePackageDetails
     * Meta informations extracted from the WSDL
     * - documentation: Shipping Package level details for the enclosing shipping service, this complex type replaces the existing ShippingPackage type.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ebay\StructType\ShippingServicePackageDetailsType[]
     */
    public $ShippingServicePackageDetails;
    /**
     * The WeightRequired
     * Meta informations extracted from the WSDL
     * - documentation: If true, a seller who selects this package type for the listing and then offers this shipping service must specify WeightMajor and WeightMinor in the item definition. If not returned, WeightRequired is false.
     * - minOccurs: 0
     * @var bool
     */
    public $WeightRequired;
    /**
     * The DetailVersion
     * Meta informations extracted from the WSDL
     * - documentation: Returns the latest version number for this field. The version can be used to determine if and when to refresh cached client data.
     * - minOccurs: 0
     * @var string
     */
    public $DetailVersion;
    /**
     * The UpdateTime
     * Meta informations extracted from the WSDL
     * - documentation: Gives the time in GMT that the feature flags for the details were last updated. This timestamp can be used to determine if and when to refresh cached client data.
     * - minOccurs: 0
     * @var string
     */
    public $UpdateTime;
    /**
     * The ShippingCategory
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the shipping category. Shipping categories include the following: <code>ECONOMY</code>, <code>STANDARD</code>, <code>EXPEDITED</code>, <code>ONE_DAY</code>, <code>PICKUP</code>, <code>OTHER</code>, and <code>NONE</code>.
     * International shipping services are generally grouped into the <code>NONE</code> category. For more information about these shipping categories, see the <a href="http://pages.ebay.com/sellerinformation/shipping/chooseservice.html">Shipping Basics</a>
     * page on the eBay Shipping Center site. <br/><br/> <span class="tablenote"> <strong>Note:</strong> This field is returned only for those sites that support shipping categories: US (0), CA (2), CAFR (210), UK (3), AU (15), FR (71), DE (77), IT (101)
     * and ES (186). </span>
     * - minOccurs: 0
     * @var string
     */
    public $ShippingCategory;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for ShippingServiceDetailsType
     * @uses ShippingServiceDetailsType::setDescription()
     * @uses ShippingServiceDetailsType::setExpeditedService()
     * @uses ShippingServiceDetailsType::setInternationalService()
     * @uses ShippingServiceDetailsType::setShippingService()
     * @uses ShippingServiceDetailsType::setShippingServiceID()
     * @uses ShippingServiceDetailsType::setShippingTimeMax()
     * @uses ShippingServiceDetailsType::setShippingTimeMin()
     * @uses ShippingServiceDetailsType::setShippingServiceCode()
     * @uses ShippingServiceDetailsType::setServiceType()
     * @uses ShippingServiceDetailsType::setShippingPackage()
     * @uses ShippingServiceDetailsType::setDimensionsRequired()
     * @uses ShippingServiceDetailsType::setValidForSellingFlow()
     * @uses ShippingServiceDetailsType::setSurchargeApplicable()
     * @uses ShippingServiceDetailsType::setShippingCarrier()
     * @uses ShippingServiceDetailsType::setCODService()
     * @uses ShippingServiceDetailsType::setDeprecationDetails()
     * @uses ShippingServiceDetailsType::setMappedToShippingServiceID()
     * @uses ShippingServiceDetailsType::setCostGroupFlat()
     * @uses ShippingServiceDetailsType::setShippingServicePackageDetails()
     * @uses ShippingServiceDetailsType::setWeightRequired()
     * @uses ShippingServiceDetailsType::setDetailVersion()
     * @uses ShippingServiceDetailsType::setUpdateTime()
     * @uses ShippingServiceDetailsType::setShippingCategory()
     * @uses ShippingServiceDetailsType::setAny()
     * @param string $description
     * @param bool $expeditedService
     * @param bool $internationalService
     * @param string $shippingService
     * @param int $shippingServiceID
     * @param int $shippingTimeMax
     * @param int $shippingTimeMin
     * @param string $shippingServiceCode
     * @param string[] $serviceType
     * @param string[] $shippingPackage
     * @param bool $dimensionsRequired
     * @param bool $validForSellingFlow
     * @param bool $surchargeApplicable
     * @param string[] $shippingCarrier
     * @param bool $cODService
     * @param \ebay\StructType\AnnouncementMessageType[] $deprecationDetails
     * @param int $mappedToShippingServiceID
     * @param string $costGroupFlat
     * @param \ebay\StructType\ShippingServicePackageDetailsType[] $shippingServicePackageDetails
     * @param bool $weightRequired
     * @param string $detailVersion
     * @param string $updateTime
     * @param string $shippingCategory
     * @param \DOMDocument $any
     */
    public function __construct($description = null, $expeditedService = null, $internationalService = null, $shippingService = null, $shippingServiceID = null, $shippingTimeMax = null, $shippingTimeMin = null, $shippingServiceCode = null, array $serviceType = array(), array $shippingPackage = array(), $dimensionsRequired = null, $validForSellingFlow = null, $surchargeApplicable = null, array $shippingCarrier = array(), $cODService = null, array $deprecationDetails = array(), $mappedToShippingServiceID = null, $costGroupFlat = null, array $shippingServicePackageDetails = array(), $weightRequired = null, $detailVersion = null, $updateTime = null, $shippingCategory = null, \DOMDocument $any = null)
    {
        $this
            ->setDescription($description)
            ->setExpeditedService($expeditedService)
            ->setInternationalService($internationalService)
            ->setShippingService($shippingService)
            ->setShippingServiceID($shippingServiceID)
            ->setShippingTimeMax($shippingTimeMax)
            ->setShippingTimeMin($shippingTimeMin)
            ->setShippingServiceCode($shippingServiceCode)
            ->setServiceType($serviceType)
            ->setShippingPackage($shippingPackage)
            ->setDimensionsRequired($dimensionsRequired)
            ->setValidForSellingFlow($validForSellingFlow)
            ->setSurchargeApplicable($surchargeApplicable)
            ->setShippingCarrier($shippingCarrier)
            ->setCODService($cODService)
            ->setDeprecationDetails($deprecationDetails)
            ->setMappedToShippingServiceID($mappedToShippingServiceID)
            ->setCostGroupFlat($costGroupFlat)
            ->setShippingServicePackageDetails($shippingServicePackageDetails)
            ->setWeightRequired($weightRequired)
            ->setDetailVersion($detailVersion)
            ->setUpdateTime($updateTime)
            ->setShippingCategory($shippingCategory)
            ->setAny($any);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ExpeditedService value
     * @return bool|null
     */
    public function getExpeditedService()
    {
        return $this->ExpeditedService;
    }
    /**
     * Set ExpeditedService value
     * @param bool $expeditedService
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setExpeditedService($expeditedService = null)
    {
        $this->ExpeditedService = $expeditedService;
        return $this;
    }
    /**
     * Get InternationalService value
     * @return bool|null
     */
    public function getInternationalService()
    {
        return $this->InternationalService;
    }
    /**
     * Set InternationalService value
     * @param bool $internationalService
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setInternationalService($internationalService = null)
    {
        $this->InternationalService = $internationalService;
        return $this;
    }
    /**
     * Get ShippingService value
     * @return string|null
     */
    public function getShippingService()
    {
        return $this->ShippingService;
    }
    /**
     * Set ShippingService value
     * @param string $shippingService
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setShippingService($shippingService = null)
    {
        // validation for constraint: string
        if (!is_null($shippingService) && !is_string($shippingService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingService)), __LINE__);
        }
        $this->ShippingService = $shippingService;
        return $this;
    }
    /**
     * Get ShippingServiceID value
     * @return int|null
     */
    public function getShippingServiceID()
    {
        return $this->ShippingServiceID;
    }
    /**
     * Set ShippingServiceID value
     * @param int $shippingServiceID
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setShippingServiceID($shippingServiceID = null)
    {
        // validation for constraint: int
        if (!is_null($shippingServiceID) && !is_numeric($shippingServiceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shippingServiceID)), __LINE__);
        }
        $this->ShippingServiceID = $shippingServiceID;
        return $this;
    }
    /**
     * Get ShippingTimeMax value
     * @return int|null
     */
    public function getShippingTimeMax()
    {
        return $this->ShippingTimeMax;
    }
    /**
     * Set ShippingTimeMax value
     * @param int $shippingTimeMax
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setShippingTimeMax($shippingTimeMax = null)
    {
        // validation for constraint: int
        if (!is_null($shippingTimeMax) && !is_numeric($shippingTimeMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shippingTimeMax)), __LINE__);
        }
        $this->ShippingTimeMax = $shippingTimeMax;
        return $this;
    }
    /**
     * Get ShippingTimeMin value
     * @return int|null
     */
    public function getShippingTimeMin()
    {
        return $this->ShippingTimeMin;
    }
    /**
     * Set ShippingTimeMin value
     * @param int $shippingTimeMin
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setShippingTimeMin($shippingTimeMin = null)
    {
        // validation for constraint: int
        if (!is_null($shippingTimeMin) && !is_numeric($shippingTimeMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shippingTimeMin)), __LINE__);
        }
        $this->ShippingTimeMin = $shippingTimeMin;
        return $this;
    }
    /**
     * Get ShippingServiceCode value
     * @return string|null
     */
    public function getShippingServiceCode()
    {
        return $this->ShippingServiceCode;
    }
    /**
     * Set ShippingServiceCode value
     * @uses \ebay\EnumType\ShippingServiceCodeType::valueIsValid()
     * @uses \ebay\EnumType\ShippingServiceCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shippingServiceCode
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setShippingServiceCode($shippingServiceCode = null)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\ShippingServiceCodeType::valueIsValid($shippingServiceCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $shippingServiceCode, implode(', ', \ebay\EnumType\ShippingServiceCodeType::getValidValues())), __LINE__);
        }
        $this->ShippingServiceCode = $shippingServiceCode;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return string[]|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @uses \ebay\EnumType\ShippingTypeCodeType::valueIsValid()
     * @uses \ebay\EnumType\ShippingTypeCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $serviceType
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setServiceType(array $serviceType = array())
    {
        $invalidValues = array();
        foreach ($serviceType as $shippingServiceDetailsTypeServiceTypeItem) {
            if (!\ebay\EnumType\ShippingTypeCodeType::valueIsValid($shippingServiceDetailsTypeServiceTypeItem)) {
                $invalidValues[] = var_export($shippingServiceDetailsTypeServiceTypeItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \ebay\EnumType\ShippingTypeCodeType::getValidValues())), __LINE__);
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Add item to ServiceType value
     * @uses \ebay\EnumType\ShippingTypeCodeType::valueIsValid()
     * @uses \ebay\EnumType\ShippingTypeCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function addToServiceType($item)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\ShippingTypeCodeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \ebay\EnumType\ShippingTypeCodeType::getValidValues())), __LINE__);
        }
        $this->ServiceType[] = $item;
        return $this;
    }
    /**
     * Get ShippingPackage value
     * @return string[]|null
     */
    public function getShippingPackage()
    {
        return $this->ShippingPackage;
    }
    /**
     * Set ShippingPackage value
     * @uses \ebay\EnumType\ShippingPackageCodeType::valueIsValid()
     * @uses \ebay\EnumType\ShippingPackageCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $shippingPackage
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setShippingPackage(array $shippingPackage = array())
    {
        $invalidValues = array();
        foreach ($shippingPackage as $shippingServiceDetailsTypeShippingPackageItem) {
            if (!\ebay\EnumType\ShippingPackageCodeType::valueIsValid($shippingServiceDetailsTypeShippingPackageItem)) {
                $invalidValues[] = var_export($shippingServiceDetailsTypeShippingPackageItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \ebay\EnumType\ShippingPackageCodeType::getValidValues())), __LINE__);
        }
        $this->ShippingPackage = $shippingPackage;
        return $this;
    }
    /**
     * Add item to ShippingPackage value
     * @uses \ebay\EnumType\ShippingPackageCodeType::valueIsValid()
     * @uses \ebay\EnumType\ShippingPackageCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function addToShippingPackage($item)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\ShippingPackageCodeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \ebay\EnumType\ShippingPackageCodeType::getValidValues())), __LINE__);
        }
        $this->ShippingPackage[] = $item;
        return $this;
    }
    /**
     * Get DimensionsRequired value
     * @return bool|null
     */
    public function getDimensionsRequired()
    {
        return $this->DimensionsRequired;
    }
    /**
     * Set DimensionsRequired value
     * @param bool $dimensionsRequired
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setDimensionsRequired($dimensionsRequired = null)
    {
        $this->DimensionsRequired = $dimensionsRequired;
        return $this;
    }
    /**
     * Get ValidForSellingFlow value
     * @return bool|null
     */
    public function getValidForSellingFlow()
    {
        return $this->ValidForSellingFlow;
    }
    /**
     * Set ValidForSellingFlow value
     * @param bool $validForSellingFlow
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setValidForSellingFlow($validForSellingFlow = null)
    {
        $this->ValidForSellingFlow = $validForSellingFlow;
        return $this;
    }
    /**
     * Get SurchargeApplicable value
     * @return bool|null
     */
    public function getSurchargeApplicable()
    {
        return $this->SurchargeApplicable;
    }
    /**
     * Set SurchargeApplicable value
     * @param bool $surchargeApplicable
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setSurchargeApplicable($surchargeApplicable = null)
    {
        $this->SurchargeApplicable = $surchargeApplicable;
        return $this;
    }
    /**
     * Get ShippingCarrier value
     * @return string[]|null
     */
    public function getShippingCarrier()
    {
        return $this->ShippingCarrier;
    }
    /**
     * Set ShippingCarrier value
     * @uses \ebay\EnumType\ShippingCarrierCodeType::valueIsValid()
     * @uses \ebay\EnumType\ShippingCarrierCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $shippingCarrier
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setShippingCarrier(array $shippingCarrier = array())
    {
        $invalidValues = array();
        foreach ($shippingCarrier as $shippingServiceDetailsTypeShippingCarrierItem) {
            if (!\ebay\EnumType\ShippingCarrierCodeType::valueIsValid($shippingServiceDetailsTypeShippingCarrierItem)) {
                $invalidValues[] = var_export($shippingServiceDetailsTypeShippingCarrierItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \ebay\EnumType\ShippingCarrierCodeType::getValidValues())), __LINE__);
        }
        $this->ShippingCarrier = $shippingCarrier;
        return $this;
    }
    /**
     * Add item to ShippingCarrier value
     * @uses \ebay\EnumType\ShippingCarrierCodeType::valueIsValid()
     * @uses \ebay\EnumType\ShippingCarrierCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function addToShippingCarrier($item)
    {
        // validation for constraint: enumeration
        if (!\ebay\EnumType\ShippingCarrierCodeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \ebay\EnumType\ShippingCarrierCodeType::getValidValues())), __LINE__);
        }
        $this->ShippingCarrier[] = $item;
        return $this;
    }
    /**
     * Get CODService value
     * @return bool|null
     */
    public function getCODService()
    {
        return $this->CODService;
    }
    /**
     * Set CODService value
     * @param bool $cODService
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setCODService($cODService = null)
    {
        $this->CODService = $cODService;
        return $this;
    }
    /**
     * Get DeprecationDetails value
     * @return \ebay\StructType\AnnouncementMessageType[]|null
     */
    public function getDeprecationDetails()
    {
        return $this->DeprecationDetails;
    }
    /**
     * Set DeprecationDetails value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\AnnouncementMessageType[] $deprecationDetails
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setDeprecationDetails(array $deprecationDetails = array())
    {
        foreach ($deprecationDetails as $shippingServiceDetailsTypeDeprecationDetailsItem) {
            // validation for constraint: itemType
            if (!$shippingServiceDetailsTypeDeprecationDetailsItem instanceof \ebay\StructType\AnnouncementMessageType) {
                throw new \InvalidArgumentException(sprintf('The DeprecationDetails property can only contain items of \ebay\StructType\AnnouncementMessageType, "%s" given', is_object($shippingServiceDetailsTypeDeprecationDetailsItem) ? get_class($shippingServiceDetailsTypeDeprecationDetailsItem) : gettype($shippingServiceDetailsTypeDeprecationDetailsItem)), __LINE__);
            }
        }
        $this->DeprecationDetails = $deprecationDetails;
        return $this;
    }
    /**
     * Add item to DeprecationDetails value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\AnnouncementMessageType $item
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function addToDeprecationDetails(\ebay\StructType\AnnouncementMessageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\AnnouncementMessageType) {
            throw new \InvalidArgumentException(sprintf('The DeprecationDetails property can only contain items of \ebay\StructType\AnnouncementMessageType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeprecationDetails[] = $item;
        return $this;
    }
    /**
     * Get MappedToShippingServiceID value
     * @return int|null
     */
    public function getMappedToShippingServiceID()
    {
        return $this->MappedToShippingServiceID;
    }
    /**
     * Set MappedToShippingServiceID value
     * @param int $mappedToShippingServiceID
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setMappedToShippingServiceID($mappedToShippingServiceID = null)
    {
        // validation for constraint: int
        if (!is_null($mappedToShippingServiceID) && !is_numeric($mappedToShippingServiceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mappedToShippingServiceID)), __LINE__);
        }
        $this->MappedToShippingServiceID = $mappedToShippingServiceID;
        return $this;
    }
    /**
     * Get CostGroupFlat value
     * @return string|null
     */
    public function getCostGroupFlat()
    {
        return $this->CostGroupFlat;
    }
    /**
     * Set CostGroupFlat value
     * @param string $costGroupFlat
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setCostGroupFlat($costGroupFlat = null)
    {
        // validation for constraint: string
        if (!is_null($costGroupFlat) && !is_string($costGroupFlat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($costGroupFlat)), __LINE__);
        }
        $this->CostGroupFlat = $costGroupFlat;
        return $this;
    }
    /**
     * Get ShippingServicePackageDetails value
     * @return \ebay\StructType\ShippingServicePackageDetailsType[]|null
     */
    public function getShippingServicePackageDetails()
    {
        return $this->ShippingServicePackageDetails;
    }
    /**
     * Set ShippingServicePackageDetails value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ShippingServicePackageDetailsType[] $shippingServicePackageDetails
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setShippingServicePackageDetails(array $shippingServicePackageDetails = array())
    {
        foreach ($shippingServicePackageDetails as $shippingServiceDetailsTypeShippingServicePackageDetailsItem) {
            // validation for constraint: itemType
            if (!$shippingServiceDetailsTypeShippingServicePackageDetailsItem instanceof \ebay\StructType\ShippingServicePackageDetailsType) {
                throw new \InvalidArgumentException(sprintf('The ShippingServicePackageDetails property can only contain items of \ebay\StructType\ShippingServicePackageDetailsType, "%s" given', is_object($shippingServiceDetailsTypeShippingServicePackageDetailsItem) ? get_class($shippingServiceDetailsTypeShippingServicePackageDetailsItem) : gettype($shippingServiceDetailsTypeShippingServicePackageDetailsItem)), __LINE__);
            }
        }
        $this->ShippingServicePackageDetails = $shippingServicePackageDetails;
        return $this;
    }
    /**
     * Add item to ShippingServicePackageDetails value
     * @throws \InvalidArgumentException
     * @param \ebay\StructType\ShippingServicePackageDetailsType $item
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function addToShippingServicePackageDetails(\ebay\StructType\ShippingServicePackageDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ebay\StructType\ShippingServicePackageDetailsType) {
            throw new \InvalidArgumentException(sprintf('The ShippingServicePackageDetails property can only contain items of \ebay\StructType\ShippingServicePackageDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShippingServicePackageDetails[] = $item;
        return $this;
    }
    /**
     * Get WeightRequired value
     * @return bool|null
     */
    public function getWeightRequired()
    {
        return $this->WeightRequired;
    }
    /**
     * Set WeightRequired value
     * @param bool $weightRequired
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setWeightRequired($weightRequired = null)
    {
        $this->WeightRequired = $weightRequired;
        return $this;
    }
    /**
     * Get DetailVersion value
     * @return string|null
     */
    public function getDetailVersion()
    {
        return $this->DetailVersion;
    }
    /**
     * Set DetailVersion value
     * @param string $detailVersion
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setDetailVersion($detailVersion = null)
    {
        // validation for constraint: string
        if (!is_null($detailVersion) && !is_string($detailVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($detailVersion)), __LINE__);
        }
        $this->DetailVersion = $detailVersion;
        return $this;
    }
    /**
     * Get UpdateTime value
     * @return string|null
     */
    public function getUpdateTime()
    {
        return $this->UpdateTime;
    }
    /**
     * Set UpdateTime value
     * @param string $updateTime
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setUpdateTime($updateTime = null)
    {
        // validation for constraint: string
        if (!is_null($updateTime) && !is_string($updateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateTime)), __LINE__);
        }
        $this->UpdateTime = $updateTime;
        return $this;
    }
    /**
     * Get ShippingCategory value
     * @return string|null
     */
    public function getShippingCategory()
    {
        return $this->ShippingCategory;
    }
    /**
     * Set ShippingCategory value
     * @param string $shippingCategory
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setShippingCategory($shippingCategory = null)
    {
        // validation for constraint: string
        if (!is_null($shippingCategory) && !is_string($shippingCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingCategory)), __LINE__);
        }
        $this->ShippingCategory = $shippingCategory;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \ebay\StructType\ShippingServiceDetailsType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ebay\StructType\ShippingServiceDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
